/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.obfuscation.jackson;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.gradle.obfuscation.ObfuscationControl;
import com.gradle.obfuscation.jackson.JacksonObfuscationVerificationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class ObfuscationSafetyVerificationModule
extends SimpleModule {
    public ObfuscationSafetyVerificationModule() {
        this.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                List reflectivelyNamed;
                Class<?> beanClass = beanDesc.getBeanClass();
                if (!ObfuscationControl.retainsPropertyNames(beanClass) && !(reflectivelyNamed = beanProperties.stream().filter(p2 -> ObfuscationSafetyVerificationModule.isReflectivelyNamed(p2.getMember())).map(BeanPropertyWriter::toString).collect(Collectors.toList())).isEmpty()) {
                    throw new JacksonObfuscationVerificationException(beanClass.getName() + " is not safe to serialize (members: " + reflectivelyNamed + ")");
                }
                return super.changeProperties(config, beanDesc, beanProperties);
            }
        });
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
                Class<?> beanClass = beanDesc.getBeanClass();
                if (!ObfuscationControl.retainsPropertyNames(beanClass) && ObfuscationSafetyVerificationModule.mightUsePropertyNameReflection(builder)) {
                    Iterator<SettableBeanProperty> properties = builder.getProperties();
                    ArrayList reflectivelyNamed = new ArrayList();
                    properties.forEachRemaining(p2 -> {
                        if (ObfuscationSafetyVerificationModule.isReflectivelyNamed(p2.getMember())) {
                            reflectivelyNamed.add(p2.getMember().toString());
                        }
                    });
                    if (!reflectivelyNamed.isEmpty()) {
                        throw new JacksonObfuscationVerificationException(beanClass.getName() + " is not safe to deserialize (members: " + reflectivelyNamed + ")");
                    }
                }
                return super.updateBuilder(config, beanDesc, builder);
            }
        });
    }

    private static boolean mightUsePropertyNameReflection(BeanDeserializerBuilder builder) {
        ValueInstantiator valueInstantiator = builder.getValueInstantiator();
        return valueInstantiator.canInstantiate() && valueInstantiator.canCreateUsingDefault() && !valueInstantiator.canCreateUsingDelegate() && !valueInstantiator.canCreateFromObjectWith();
    }

    private static boolean isReflectivelyNamed(AnnotatedMember member) {
        JsonProperty jsonProperty = member.getAnnotation(JsonProperty.class);
        return jsonProperty == null || jsonProperty.value().equals("");
    }
}

