/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.AnyWildcardPatternStep;
import org.gradle.api.internal.file.pattern.FixedPatternStep;
import org.gradle.api.internal.file.pattern.HasPrefixAndSuffixPatternStep;
import org.gradle.api.internal.file.pattern.HasPrefixPatternStep;
import org.gradle.api.internal.file.pattern.HasSuffixPatternStep;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.RegExpPatternStep;

public class PatternStepFactory {
    private static final AnyWildcardPatternStep ANY_WILDCARD_PATTERN_STEP = new AnyWildcardPatternStep();

    public static PatternStep getStep(String source, boolean caseSensitive) {
        int endSuffixWildcard;
        int endLiteral;
        if (source.length() == 0) {
            return new FixedPatternStep(source, caseSensitive);
        }
        char ch2 = source.charAt(0);
        int endPrefixWildcard = 0;
        if (ch2 == '*') {
            for (endPrefixWildcard = 1; endPrefixWildcard < source.length() && source.charAt(endPrefixWildcard) == '*'; ++endPrefixWildcard) {
            }
        }
        if (endPrefixWildcard == source.length()) {
            return ANY_WILDCARD_PATTERN_STEP;
        }
        for (endLiteral = endPrefixWildcard; endLiteral < source.length(); ++endLiteral) {
            ch2 = source.charAt(endLiteral);
            if (ch2 == '?') {
                return new RegExpPatternStep(source, caseSensitive);
            }
            if (ch2 == '*') break;
        }
        if (endLiteral == source.length()) {
            if (endPrefixWildcard == 0) {
                return new FixedPatternStep(source, caseSensitive);
            }
            return new HasSuffixPatternStep(source.substring(endPrefixWildcard), caseSensitive);
        }
        if (endPrefixWildcard > 0) {
            return new RegExpPatternStep(source, caseSensitive);
        }
        for (endSuffixWildcard = endLiteral; endSuffixWildcard < source.length() && (ch2 = source.charAt(endSuffixWildcard)) == '*'; ++endSuffixWildcard) {
        }
        if (endSuffixWildcard == source.length()) {
            return new HasPrefixPatternStep(source.substring(0, endLiteral), caseSensitive);
        }
        for (int i2 = endSuffixWildcard; i2 < source.length(); ++i2) {
            ch2 = source.charAt(i2);
            if (ch2 != '?' && ch2 != '*') continue;
            return new RegExpPatternStep(source, caseSensitive);
        }
        return new HasPrefixAndSuffixPatternStep(source.substring(0, endLiteral), source.substring(endSuffixWildcard), caseSensitive);
    }
}

