/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;
import java.util.Properties;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginMetadataFactory.class);
    private final String userName;
    private final String operatingSystem;
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;
    private final HostnameLookup hostnameLookup;

    public OriginMetadataFactory(String userName, String operatingSystem, String currentBuildInvocationId, PropertiesConfigurator additionalProperties, HostnameLookup hostnameLookup) {
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.additionalProperties = additionalProperties;
        this.currentBuildInvocationId = currentBuildInvocationId;
        this.hostnameLookup = hostnameLookup;
    }

    public OriginWriter createWriter(CacheableEntity entry, Duration elapsedTime) {
        return outputStream -> {
            Properties properties = new Properties();
            properties.setProperty("buildInvocationId", this.currentBuildInvocationId);
            properties.setProperty("type", entry.getType().getCanonicalName());
            properties.setProperty("identity", entry.getIdentity());
            properties.setProperty("creationTime", Long.toString(System.currentTimeMillis()));
            properties.setProperty("executionTime", Long.toString(elapsedTime.toMillis()));
            properties.setProperty("operatingSystem", this.operatingSystem);
            properties.setProperty("hostName", this.hostnameLookup.getHostname());
            properties.setProperty("userName", this.userName);
            this.additionalProperties.configure(properties);
            properties.store(outputStream, "Generated origin information");
        };
    }

    public OriginReader createReader(CacheableEntity entry) {
        return inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Origin for {}: {}", (Object)entry.getDisplayName(), (Object)properties);
            }
            String originBuildInvocationId = properties.getProperty("buildInvocationId");
            String executionTimeAsString = properties.getProperty("executionTime");
            if (originBuildInvocationId == null || executionTimeAsString == null) {
                throw new IllegalStateException("Cached result format error, corrupted origin metadata");
            }
            Duration originalExecutionTime = Duration.ofMillis(Long.parseLong(executionTimeAsString));
            return new OriginMetadata(originBuildInvocationId, originalExecutionTime);
        };
    }

    public static interface HostnameLookup {
        public String getHostname();
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

