/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Charsets;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.hash.PrimitiveHasher;

public class Hashing {
    private static final HashFunction MD5 = MessageDigestHashFunction.of("MD5");
    private static final HashFunction SHA1 = MessageDigestHashFunction.of("SHA-1");
    private static final HashFunction SHA256 = MessageDigestHashFunction.of("SHA-256");
    private static final HashFunction SHA512 = MessageDigestHashFunction.of("SHA-512");
    private static final HashFunction DEFAULT = MD5;

    public static Hasher newHasher() {
        return DEFAULT.newHasher();
    }

    public static PrimitiveHasher newPrimitiveHasher() {
        return DEFAULT.newPrimitiveHasher();
    }

    public static HashCode signature(Class<?> type) {
        return Hashing.signature("CLASS:" + type.getName());
    }

    public static HashCode signature(String thing) {
        Hasher hasher = DEFAULT.newHasher();
        hasher.putString("SIGNATURE");
        hasher.putString(thing);
        return hasher.hash();
    }

    public static HashCode hashBytes(byte[] bytes) {
        return DEFAULT.hashBytes(bytes);
    }

    public static HashCode hashStream(InputStream stream) throws IOException {
        return DEFAULT.hashStream(stream);
    }

    private static class DefaultHasher
    implements Hasher {
        private final PrimitiveHasher hasher;

        public DefaultHasher(PrimitiveHasher unsafeHasher) {
            this.hasher = unsafeHasher;
        }

        @Override
        public void putByte(byte value) {
            this.hasher.putInt(1);
            this.hasher.putByte(value);
        }

        @Override
        public void putBytes(byte[] bytes) {
            this.hasher.putInt(bytes.length);
            this.hasher.putBytes(bytes);
        }

        @Override
        public void putBytes(byte[] bytes, int off, int len) {
            this.hasher.putInt(len);
            this.hasher.putBytes(bytes, off, len);
        }

        @Override
        public void putHash(HashCode hashCode) {
            this.hasher.putInt(hashCode.length());
            this.hasher.putHash(hashCode);
        }

        @Override
        public void putInt(int value) {
            this.hasher.putInt(4);
            this.hasher.putInt(value);
        }

        @Override
        public void putLong(long value) {
            this.hasher.putInt(8);
            this.hasher.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            this.hasher.putInt(8);
            this.hasher.putDouble(value);
        }

        @Override
        public void putBoolean(boolean value) {
            this.hasher.putInt(1);
            this.hasher.putBoolean(value);
        }

        @Override
        public void putString(CharSequence value) {
            this.hasher.putInt(value.length());
            this.hasher.putString(value);
        }

        @Override
        public void putNull() {
            this.putInt(0);
        }

        @Override
        public HashCode hash() {
            return this.hasher.hash();
        }
    }

    private static class MessageDigestHasher
    implements PrimitiveHasher {
        private final ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        private MessageDigest digest;

        public MessageDigestHasher(MessageDigest digest) {
            this.digest = digest;
        }

        private MessageDigest getDigest() {
            if (this.digest == null) {
                throw new IllegalStateException("Cannot reuse hasher!");
            }
            return this.digest;
        }

        @Override
        public void putByte(byte b2) {
            this.getDigest().update(b2);
        }

        @Override
        public void putBytes(byte[] bytes) {
            this.getDigest().update(bytes);
        }

        @Override
        public void putBytes(byte[] bytes, int off, int len) {
            this.getDigest().update(bytes, off, len);
        }

        private void update(int length) {
            this.getDigest().update(this.buffer.array(), 0, length);
            MessageDigestHasher.castBuffer(this.buffer).clear();
        }

        private static <T extends Buffer> Buffer castBuffer(T byteBuffer) {
            return byteBuffer;
        }

        @Override
        public void putInt(int value) {
            this.buffer.putInt(value);
            this.update(4);
        }

        @Override
        public void putLong(long value) {
            this.buffer.putLong(value);
            this.update(8);
        }

        @Override
        public void putDouble(double value) {
            long longValue = Double.doubleToRawLongBits(value);
            this.putLong(longValue);
        }

        @Override
        public void putBoolean(boolean value) {
            this.putByte((byte)(value ? 1 : 0));
        }

        @Override
        public void putString(CharSequence value) {
            this.putBytes(value.toString().getBytes(Charsets.UTF_8));
        }

        @Override
        public void putHash(HashCode hashCode) {
            hashCode.appendToHasher(this);
        }

        @Override
        public HashCode hash() {
            byte[] bytes = this.getDigest().digest();
            this.digest = null;
            return HashCode.fromBytes(bytes, HashCode.Usage.SAFE_TO_REUSE_BYTES);
        }
    }

    private static class RegularMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final String algorithm;

        public RegularMessageDigestHashFunction(String algorithm, int hashBits) {
            super(hashBits);
            this.algorithm = algorithm;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        protected MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    private static class CloningMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final MessageDigest prototype;

        public CloningMessageDigestHashFunction(MessageDigest prototype, int hashBits) {
            super(hashBits);
            this.prototype = prototype;
        }

        @Override
        public String getAlgorithm() {
            return this.prototype.getAlgorithm();
        }

        @Override
        protected MessageDigest createDigest() {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    private static abstract class MessageDigestHashFunction
    implements HashFunction {
        private final int hexDigits;

        public MessageDigestHashFunction(int hashBits) {
            this.hexDigits = hashBits / 4;
        }

        public static MessageDigestHashFunction of(String algorithm) {
            MessageDigest prototype;
            try {
                prototype = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new IllegalArgumentException("Cannot instantiate digest algorithm: " + algorithm);
            }
            int hashBits = prototype.getDigestLength() * 8;
            try {
                prototype.clone();
                return new CloningMessageDigestHashFunction(prototype, hashBits);
            }
            catch (CloneNotSupportedException e3) {
                return new RegularMessageDigestHashFunction(algorithm, hashBits);
            }
        }

        @Override
        public PrimitiveHasher newPrimitiveHasher() {
            MessageDigest digest = this.createDigest();
            return new MessageDigestHasher(digest);
        }

        @Override
        public Hasher newHasher() {
            return new DefaultHasher(this.newPrimitiveHasher());
        }

        @Override
        public HashCode hashBytes(byte[] bytes) {
            PrimitiveHasher hasher = this.newPrimitiveHasher();
            hasher.putBytes(bytes);
            return hasher.hash();
        }

        @Override
        public HashCode hashStream(InputStream stream) throws IOException {
            HashingOutputStream hashingOutputStream = this.primitiveStreamHasher();
            ByteStreams.copy(stream, hashingOutputStream);
            return hashingOutputStream.hash();
        }

        private HashingOutputStream primitiveStreamHasher() {
            return new HashingOutputStream(this, ByteStreams.nullOutputStream());
        }

        protected abstract MessageDigest createDigest();

        public String toString() {
            return this.getAlgorithm();
        }
    }
}

