/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

@FunctionalInterface
public interface IoSupplier<T> {
    public T get() throws IOException;

    public static <T> Supplier<T> wrap(IoSupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        };
    }
}

