/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.Type;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.SortedSet;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.TypedMember;

public class MethodMember
extends TypedMember
implements Comparable<MethodMember> {
    private static final Ordering<Iterable<String>> LEXICOGRAPHICAL_ORDERING = Ordering.natural().lexicographical();
    private final SortedSet<String> exceptions = Sets.newTreeSet();
    private final SortedSet<AnnotationMember> parameterAnnotations = Sets.newTreeSet();

    public MethodMember(int access, String name, String typeDesc, String signature, String[] exceptions) {
        super(access, name, signature, typeDesc);
        if (exceptions != null && exceptions.length > 0) {
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
    }

    public SortedSet<String> getExceptions() {
        return ImmutableSortedSet.copyOf(this.exceptions);
    }

    public SortedSet<AnnotationMember> getParameterAnnotations() {
        return ImmutableSortedSet.copyOf(this.parameterAnnotations);
    }

    public void addParameterAnnotation(ParameterAnnotationMember parameterAnnotationMember) {
        this.parameterAnnotations.add(parameterAnnotationMember);
    }

    @Override
    public int compareTo(MethodMember o2) {
        return super.compare(o2).compare(this.exceptions, o2.exceptions, LEXICOGRAPHICAL_ORDERING).result();
    }

    public String toString() {
        StringBuilder methodDesc = new StringBuilder();
        methodDesc.append(Modifier.toString(this.getAccess())).append(" ");
        methodDesc.append(Type.getReturnType(this.getTypeDesc()).getClassName()).append(" ");
        methodDesc.append(this.getName());
        methodDesc.append("(");
        Type[] argumentTypes = Type.getArgumentTypes(this.getTypeDesc());
        int argumentTypesLength = argumentTypes.length;
        for (int i2 = 0; i2 < argumentTypesLength; ++i2) {
            Type type = argumentTypes[i2];
            methodDesc.append(type.getClassName());
            if (i2 >= argumentTypesLength - 1) continue;
            methodDesc.append(", ");
        }
        methodDesc.append(")");
        return methodDesc.toString();
    }
}

