/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;

public final class BuildOperationDescriptor {
    private final OperationIdentifier id;
    private final OperationIdentifier parentId;
    private final String displayName;
    private final String name;
    private final String progressDisplayName;
    private final Object details;
    private final BuildOperationMetadata metadata;
    private final int totalProgress;

    private BuildOperationDescriptor(OperationIdentifier id, OperationIdentifier parentId, String name, String displayName, String progressDisplayName, Object details, BuildOperationMetadata metadata, int totalProgress) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.displayName = displayName;
        this.progressDisplayName = progressDisplayName;
        this.details = details;
        this.metadata = metadata;
        this.totalProgress = totalProgress;
    }

    public OperationIdentifier getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Object getDetails() {
        return this.details;
    }

    public OperationIdentifier getParentId() {
        return this.parentId;
    }

    public static Builder displayName(String displayName) {
        return new Builder(displayName);
    }

    public static final class Builder {
        private final String displayName;
        private String name;
        private String progressDisplayName;
        private Object details;
        private BuildOperationRef parent;
        private BuildOperationMetadata metadata = BuildOperationMetadata.NONE;
        private int totalProgress;

        private Builder(String displayName) {
            this.displayName = displayName;
            this.name = displayName;
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        BuildOperationRef getParentState() {
            return this.parent;
        }

        public BuildOperationDescriptor build(OperationIdentifier id, OperationIdentifier defaultParentId) {
            return new BuildOperationDescriptor(id, this.parent == null ? defaultParentId : this.parent.getId(), this.name, this.displayName, this.progressDisplayName, this.details, this.metadata, this.totalProgress);
        }
    }
}

