/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.List;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.LargeChildMap;
import org.gradle.internal.snapshot.MediumChildMap;
import org.gradle.internal.snapshot.SingletonChildMap;

public class ChildMapFactory {
    public static <T> ChildMap<T> childMapFromSorted(List<ChildMap.Entry<T>> sortedEntries) {
        int size = sortedEntries.size();
        switch (size) {
            case 0: {
                return EmptyChildMap.getInstance();
            }
            case 1: {
                return new SingletonChildMap<T>(sortedEntries.get(0));
            }
        }
        return size < 10 ? new MediumChildMap<T>(sortedEntries) : new LargeChildMap<T>(sortedEntries);
    }
}

