/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class DirectorySnapshot
extends AbstractFileSystemLocationSnapshot {
    private final ChildMap<FileSystemLocationSnapshot> children;
    private final HashCode contentHash;

    public DirectorySnapshot(String absolutePath, String name, FileMetadata.AccessType accessType, HashCode contentHash, List<FileSystemLocationSnapshot> children) {
        this(absolutePath, name, accessType, contentHash, ChildMapFactory.childMapFromSorted(children.stream().map(it -> new ChildMap.Entry<FileSystemLocationSnapshot>(it.getName(), (FileSystemLocationSnapshot)it)).collect(Collectors.toList())));
    }

    public DirectorySnapshot(String absolutePath, String name, FileMetadata.AccessType accessType, HashCode contentHash, ChildMap<FileSystemLocationSnapshot> children) {
        super(absolutePath, name, accessType);
        this.contentHash = contentHash;
        this.children = children;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public FileType getType() {
        return FileType.Directory;
    }

    @Override
    public SnapshotVisitResult accept(FileSystemSnapshotHierarchyVisitor visitor) {
        SnapshotVisitResult result = visitor.visitEntry(this);
        switch (result) {
            case CONTINUE: {
                visitor.enterDirectory(this);
                this.children.stream().map(ChildMap.Entry::getValue).forEach(child -> child.accept(visitor));
                visitor.leaveDirectory(this);
                return SnapshotVisitResult.CONTINUE;
            }
            case SKIP_SUBTREE: {
                return SnapshotVisitResult.CONTINUE;
            }
            case TERMINATE: {
                return SnapshotVisitResult.TERMINATE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public SnapshotVisitResult accept(RelativePathTracker pathTracker, RelativePathTrackingFileSystemSnapshotHierarchyVisitor visitor) {
        pathTracker.enter(this.getName());
        try {
            SnapshotVisitResult result = visitor.visitEntry(this, pathTracker);
            switch (result) {
                case CONTINUE: {
                    visitor.enterDirectory(this, pathTracker);
                    this.children.stream().map(ChildMap.Entry::getValue).forEach(child -> child.accept(pathTracker, visitor));
                    visitor.leaveDirectory(this, pathTracker);
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult;
                }
                case SKIP_SUBTREE: {
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult;
                }
                case TERMINATE: {
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.TERMINATE;
                    return snapshotVisitResult;
                }
            }
            throw new AssertionError();
        }
        finally {
            pathTracker.leave();
        }
    }

    @Override
    public void accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor visitor) {
        visitor.visitDirectory(this);
    }

    @Override
    public <T> T accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<T> transformer) {
        return transformer.visitDirectory(this);
    }

    public ImmutableList<FileSystemLocationSnapshot> getChildren() {
        return this.children.stream().map(ChildMap.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    public String toString() {
        return String.format("%s@%s/%s(%s)", super.toString(), this.contentHash, this.getName(), this.children);
    }
}

