/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import org.gradle.internal.RelativePathSupplier;

public class RelativePathTracker
implements RelativePathSupplier {
    private final Deque<String> segments = new ArrayDeque<String>();
    private String rootName;

    public void enter(String name) {
        if (this.rootName == null) {
            this.rootName = name;
        } else {
            this.segments.addLast(name);
        }
    }

    public String leave() {
        String name = this.segments.pollLast();
        if (name == null) {
            name = this.rootName;
            this.rootName = null;
        }
        return name;
    }

    @Override
    public boolean isRoot() {
        return this.segments.isEmpty();
    }

    @Override
    public Collection<String> getSegments() {
        return this.segments;
    }

    @Override
    public String toRelativePath() {
        switch (this.segments.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.segments.getLast();
            }
        }
        int length = this.segments.size() - 1;
        for (String segment : this.segments) {
            length += segment.length();
        }
        StringBuilder buffer = new StringBuilder(length);
        Iterator<String> iterator = this.segments.iterator();
        while (true) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) break;
            buffer.append('/');
        }
        return buffer.toString();
    }
}

