/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.verifier;

import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.internal.verifier.HttpRedirectVerifier;

public class HttpRedirectVerifierFactory {
    public static HttpRedirectVerifier create(Consumer<URI> insecureRedirect) {
        Objects.requireNonNull(insecureRedirect, "insecureRedirect must not be null");
        return redirectLocations -> redirectLocations.stream().filter(url -> !HttpRedirectVerifierFactory.isSecureUrl(url)).forEach(insecureRedirect);
    }

    public static boolean isSecureUrl(URI url) {
        if ("127.0.0.1".equals(url.getHost())) {
            return true;
        }
        String scheme = url.getScheme();
        return !"http".equalsIgnoreCase(scheme);
    }

    public static class NoopHttpRedirectVerifier
    implements HttpRedirectVerifier {
        public static final NoopHttpRedirectVerifier INSTANCE = new NoopHttpRedirectVerifier();

        @Override
        public void validateRedirects(Collection<URI> redirectLocations) {
        }
    }
}

