/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.client.e;

import com.gradle.enterprise.agent.a.g;
import com.gradle.enterprise.b.d.e;
import com.gradle.enterprise.testdistribution.client.api.TestSelectionException;
import com.gradle.enterprise.testdistribution.client.e.h;
import com.gradle.enterprise.testdistribution.client.e.i;
import com.gradle.enterprise.testdistribution.client.e.k;
import com.gradle.enterprise.testdistribution.client.e.n;
import com.gradle.enterprise.testdistribution.launcher.protocol.message.al;
import com.gradle.enterprise.testdistribution.launcher.protocol.message.ap;
import com.gradle.enterprise.testselection.common.a.d;
import com.gradle.enterprise.testselection.common.model.api.problem.ApiProblem;
import com.gradle.enterprise.testselection.common.model.api.v1.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.v1.NonSelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.PredictiveTestSelectionApiConstants;
import com.gradle.enterprise.testselection.common.model.api.v1.ResultType;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsRequest;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsResponse;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.TestClassAndTime;
import com.gradle.enterprise.testselection.common.model.api.v1.TestTargetInputs;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.tuple.Pair;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util.BytesContentProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a
implements h {
    private static final Duration b = Duration.ofSeconds(5L);
    private static final Duration c = Duration.ofSeconds(30L);
    private static final long d = c.minus(b).toMillis();
    private static final Logger e = LoggerFactory.getLogger(a.class);
    private final HttpClient f;
    private final i g;
    private final com.gradle.enterprise.testdistribution.client.connector.d h;
    private final SmileMapper i = com.gradle.enterprise.testselection.common.a.d.a();
    private final ObjectMapper j = com.gradle.enterprise.testselection.common.a.d.b();

    a(HttpClient httpClient, i serverOptions, com.gradle.enterprise.testdistribution.client.connector.d clientInfo) {
        this.f = httpClient;
        this.g = serverOptions;
        this.h = clientInfo;
    }

    @Override
    public com.gradle.enterprise.b.f.a<n, k> selectTests(com.gradle.enterprise.version.buildagent.a buildToolType, String rootProjectName, String workUnitId, ap originalTestPlan, TestTargetInputs testTargetInputs, Optional<Duration> requestTimeout, boolean mustSelectAllTests, Set<al> mustRunTests, Consumer<String> warningsConsumer) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Pair<Set<al>, Set<al>> candidatesAndMustRun = a.a(originalTestPlan, mustRunTests, mustSelectAllTests);
        Map<ClassNameHash, al> candidatesClassNameHashes = a.a(candidatesAndMustRun.getLeft());
        Map<ClassNameHash, al> mustRunClassNameHashes = a.a(candidatesAndMustRun.getRight());
        HashMap<ClassNameHash, al> classNameHashes = new HashMap<ClassNameHash, al>(candidatesClassNameHashes);
        classNameHashes.putAll(mustRunClassNameHashes);
        Duration timeout = requestTimeout.orElseGet(() -> a.b(originalTestPlan.testCount()));
        SelectTestsRequest selectTestsRequest = SelectTestsRequest.create(rootProjectName, workUnitId, testTargetInputs, candidatesClassNameHashes.keySet(), mustRunClassNameHashes.keySet(), timeout);
        ContentResponse response = this.a(selectTestsRequest, timeout);
        int status = response.getStatus();
        e.debug("Response ({}): {}", (Object)status, (Object)response.getMediaType());
        if (status == 200 && "application/x-jackson-smile".equals(response.getMediaType())) {
            return this.a(classNameHashes, response);
        }
        if (status == 403 || status == 401) {
            if (!response.getRequest().getHeaders().contains(HttpHeader.AUTHORIZATION)) {
                g printer = new g(warningsConsumer);
                printer.a(buildToolType, this.g.f(), this.g.e().a(), null, this.g.b());
            }
            return com.gradle.enterprise.b.f.a.b(k.CLIENT_UNAUTHORIZED);
        }
        if ("application/problem+json".equals(response.getMediaType())) {
            return com.gradle.enterprise.b.f.a.b(this.a(response));
        }
        if (a.a(status)) {
            return com.gradle.enterprise.b.f.a.b(k.BUILD_AGENT_NETWORK_UNAVAILABLE);
        }
        if (HttpStatus.isServerError(status)) {
            return com.gradle.enterprise.b.f.a.b(k.SERVICE_INTERNAL_ERROR);
        }
        throw new TestSelectionException("Unexpected response from server: " + response.getStatus() + " " + response.getReason() + " (" + response.getMediaType() + ")");
    }

    private static boolean a(int status) {
        switch (status) {
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static Pair<Set<al>, Set<al>> a(ap originalTestPlan, Set<al> mustRunTests, boolean mustSelectAllTests) {
        if (mustSelectAllTests) {
            return Pair.of(Collections.emptySet(), originalTestPlan.getTestIds());
        }
        if (mustRunTests.isEmpty()) {
            return Pair.of(originalTestPlan.getTestIds(), Collections.emptySet());
        }
        Set candidates = originalTestPlan.getTestIds().stream().filter(testId -> !mustRunTests.contains(testId)).collect(Collectors.toSet());
        return Pair.of(candidates, mustRunTests);
    }

    private static Duration b(int numberOfTestClasses) {
        double timeoutFactor = Math.min(1.0, (double)numberOfTestClasses / 1000.0);
        long scaledTimeout = (long)(timeoutFactor * (double)d);
        return Duration.ofMillis(scaledTimeout).plus(b);
    }

    private com.gradle.enterprise.b.f.a<n, k> a(Map<ClassNameHash, al> classNameHashes, ContentResponse response) throws IOException {
        SelectTestsResponse selectTestsResponse = this.c(response);
        ResultType resultType = selectTestsResponse.getResultType();
        e.debug("Selection Response: {}", (Object)resultType);
        switch (resultType) {
            case SELECT_TESTS: {
                return com.gradle.enterprise.b.f.a.a(a.a(selectTestsResponse, classNameHashes));
            }
            case INSUFFICIENT_DATA: {
                return com.gradle.enterprise.b.f.a.b(k.SERVICE_INSUFFICIENT_CHANGE_HISTORY);
            }
            case PROCESSING_LAGGING: {
                return com.gradle.enterprise.b.f.a.b(k.SERVICE_UNPROCESSED_EXECUTIONS);
            }
        }
        throw new e((Object)resultType);
    }

    private k a(ContentResponse response) throws IOException {
        ApiProblem problem = this.b(response);
        e.debug("Selection Problem Response: {}", (Object)problem);
        return a.a(problem);
    }

    private static k a(ApiProblem problem) {
        String type = problem.getType();
        if (type == null) {
            throw new TestSelectionException("Unexpected problem response from server: " + problem);
        }
        switch (type) {
            case "urn:gradle:enterprise:pts:disabled": {
                return k.SERVICE_EXTENSION_DISABLED;
            }
            case "urn:gradle:enterprise:pts:timeout": 
            case "urn:gradle:enterprise:pts:unsupportedVersion": {
                return k.SERVICE_INTERNAL_ERROR;
            }
        }
        throw new TestSelectionException("Unexpected problem response from server: " + problem);
    }

    private ApiProblem b(ContentResponse response) throws IOException {
        return this.j.readValue(response.getContent(), ApiProblem.class);
    }

    private ContentResponse a(SelectTestsRequest selectTestsRequest, Duration timeout) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        URI url = this.g.f().resolve(PredictiveTestSelectionApiConstants.PTS_ENDPOINTS_BY_TOOL_TYPE.get((Object)this.h.a()));
        String requestId = UUID.randomUUID().toString();
        Request request = this.f.POST(url).content(this.a(selectTestsRequest), "application/x-jackson-smile").accept("application/x-jackson-smile", "application/problem+json").header(HttpHeader.CONTENT_ENCODING, "gzip").header("X-Request-Id", requestId).timeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.g.e().a(this.g.f().getHost(), this.g.c()).ifPresent(accessKey -> request.header(HttpHeader.AUTHORIZATION, "Bearer " + accessKey));
        if (e.isDebugEnabled()) {
            e.debug("Sending PTS request for project {}, test target {} with {} candidate tests and {} must run tests to {} with request ID {} using timeout {}", new Object[]{selectTestsRequest.getProjectCoordinates(), selectTestsRequest.getTargetPath(), selectTestsRequest.getCandidateTests().size(), selectTestsRequest.getMustRunTests().size(), url, requestId, timeout});
        }
        return request.send();
    }

    private BytesContentProvider a(SelectTestsRequest selectTestsRequest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);){
            this.i.writeValue(gzipOutputStream, (Object)selectTestsRequest);
        }
        return new BytesContentProvider(new byte[][]{baos.toByteArray()});
    }

    private SelectTestsResponse c(ContentResponse response) throws IOException {
        return this.i.readValue(response.getContent(), SelectTestsResponse.class);
    }

    private static Map<ClassNameHash, al> a(Set<al> originalTestPlan) {
        return originalTestPlan.stream().collect(Collectors.toMap(it -> ClassNameHash.hashOf(it.getLastSegment()), Function.identity()));
    }

    private static n a(SelectTestsResponse selectTestsResponse, Map<ClassNameHash, al> classNameHashes) {
        ap filteredTestPlan = a.a(classNameHashes, selectTestsResponse);
        Map<n.c, Set<al>> selectedTestClassesByReason = a.a(selectTestsResponse.getSelectedTests(), selectTestsResponse.getSelectionReasonDescriptions(), SelectionReasonId::getId, n.c::b, classNameHashes);
        Map<n.a, Set<al>> notSelectedTestClassesByReason = a.a(selectTestsResponse.getNotSelectedTests(), selectTestsResponse.getNonSelectionReasonDescriptions(), NonSelectionReasonId::getId, n.a::b, classNameHashes);
        Map<al, Duration> durationsByTestId = Stream.concat(selectTestsResponse.getSelectedTests().values().stream().flatMap(Collection::stream), selectTestsResponse.getNotSelectedTests().values().stream().flatMap(Collection::stream)).filter(it -> it.getDuration() != null).collect(Collectors.toMap(it -> (al)classNameHashes.get(it.getClassNameHash()), TestClassAndTime::getDuration));
        return n.b(filteredTestPlan, selectedTestClassesByReason, notSelectedTestClassesByReason, durationsByTestId);
    }

    private static ap a(Map<ClassNameHash, al> classNameHashes, SelectTestsResponse selectTestsResponse) {
        return ap.valid(selectTestsResponse.getSelectedTests().values().stream().flatMap(Collection::stream).map(TestClassAndTime::getClassNameHash).map(classNameHashes::get).collect(Collectors.toSet()));
    }

    private static <I, O extends n.b> Map<O, Set<al>> a(Map<I, Set<TestClassAndTime>> testsByReasonId, Map<I, String> reasonDescriptionsByReasonId, ToIntFunction<I> reasonIdExtractor, a<O> reasonFactory, Map<ClassNameHash, al> classNameHashes) {
        return testsByReasonId.entrySet().stream().collect(Collectors.toMap(entry -> reasonFactory.create(reasonIdExtractor.applyAsInt(entry.getKey()), (String)reasonDescriptionsByReasonId.get(entry.getKey())), entry -> ((Set)entry.getValue()).stream().map(TestClassAndTime::getClassNameHash).map(classNameHashes::get).collect(Collectors.toSet())));
    }

    private static interface a<T extends n.b> {
        public T create(int var1, String var2);
    }
}

