/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.enterprise.testselection.common.model.api.v1.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsRequest;
import com.gradle.enterprise.testselection.common.model.api.v1.TestTargetInputs;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="SelectTestsRequest", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableSelectTestsRequest
implements SelectTestsRequest {
    private final String projectCoordinates;
    private final String targetPath;
    private final TestTargetInputs testTargetInputs;
    private final Set<ClassNameHash> candidateTests;
    private final Set<ClassNameHash> mustRunTests;
    private final Duration timeout;

    private ImmutableSelectTestsRequest() {
        this.projectCoordinates = null;
        this.targetPath = null;
        this.testTargetInputs = null;
        this.candidateTests = null;
        this.mustRunTests = null;
        this.timeout = null;
    }

    private ImmutableSelectTestsRequest(String projectCoordinates, String targetPath, TestTargetInputs testTargetInputs, Iterable<? extends ClassNameHash> candidateTests, Iterable<? extends ClassNameHash> mustRunTests, Duration timeout) {
        this.projectCoordinates = Objects.requireNonNull(projectCoordinates, "projectCoordinates");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath");
        this.testTargetInputs = Objects.requireNonNull(testTargetInputs, "testTargetInputs");
        this.candidateTests = ImmutableSelectTestsRequest.createUnmodifiableSet(ImmutableSelectTestsRequest.createSafeList(candidateTests, true, false));
        this.mustRunTests = ImmutableSelectTestsRequest.createUnmodifiableSet(ImmutableSelectTestsRequest.createSafeList(mustRunTests, true, false));
        this.timeout = Objects.requireNonNull(timeout, "timeout");
    }

    private ImmutableSelectTestsRequest(Builder builder) {
        this.projectCoordinates = builder.projectCoordinates;
        this.targetPath = builder.targetPath;
        this.testTargetInputs = builder.testTargetInputs;
        this.candidateTests = ImmutableSelectTestsRequest.createUnmodifiableSet(builder.candidateTests);
        this.mustRunTests = ImmutableSelectTestsRequest.createUnmodifiableSet(builder.mustRunTests);
        this.timeout = builder.timeout;
    }

    @Override
    @JsonProperty(value="projectCoordinates")
    public String getProjectCoordinates() {
        return this.projectCoordinates;
    }

    @Override
    @JsonProperty(value="targetPath")
    public String getTargetPath() {
        return this.targetPath;
    }

    @Override
    @JsonProperty(value="testTargetInputs")
    public TestTargetInputs getTestTargetInputs() {
        return this.testTargetInputs;
    }

    @Override
    @JsonProperty(value="candidateTests")
    public Set<ClassNameHash> getCandidateTests() {
        return this.candidateTests;
    }

    @Override
    @JsonProperty(value="mustRunTests")
    public Set<ClassNameHash> getMustRunTests() {
        return this.mustRunTests;
    }

    @Override
    @JsonProperty(value="timeout")
    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSelectTestsRequest && this.equalTo(0, (ImmutableSelectTestsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableSelectTestsRequest another) {
        return this.projectCoordinates.equals(another.projectCoordinates) && this.targetPath.equals(another.targetPath) && this.testTargetInputs.equals(another.testTargetInputs) && this.candidateTests.equals(another.candidateTests) && this.mustRunTests.equals(another.mustRunTests) && this.timeout.equals(another.timeout);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.projectCoordinates.hashCode();
        h2 += (h2 << 5) + this.targetPath.hashCode();
        h2 += (h2 << 5) + this.testTargetInputs.hashCode();
        h2 += (h2 << 5) + this.candidateTests.hashCode();
        h2 += (h2 << 5) + this.mustRunTests.hashCode();
        h2 += (h2 << 5) + this.timeout.hashCode();
        return h2;
    }

    public String toString() {
        return "SelectTestsRequest{projectCoordinates=" + this.projectCoordinates + ", targetPath=" + this.targetPath + ", testTargetInputs=" + this.testTargetInputs + ", candidateTests=" + this.candidateTests + ", mustRunTests=" + this.mustRunTests + ", timeout=" + this.timeout + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSelectTestsRequest fromJson(Json json) {
        Builder builder = ImmutableSelectTestsRequest.builder();
        if (json.projectCoordinates != null) {
            builder.projectCoordinates(json.projectCoordinates);
        }
        if (json.targetPath != null) {
            builder.targetPath(json.targetPath);
        }
        if (json.testTargetInputs != null) {
            builder.testTargetInputs(json.testTargetInputs);
        }
        if (json.candidateTests != null) {
            builder.addAllCandidateTests(json.candidateTests);
        }
        if (json.mustRunTests != null) {
            builder.addAllMustRunTests(json.mustRunTests);
        }
        if (json.timeout != null) {
            builder.timeout(json.timeout);
        }
        return (ImmutableSelectTestsRequest)builder.build();
    }

    public static SelectTestsRequest of(String projectCoordinates, String targetPath, TestTargetInputs testTargetInputs, Set<ClassNameHash> candidateTests, Set<ClassNameHash> mustRunTests, Duration timeout) {
        return ImmutableSelectTestsRequest.of(projectCoordinates, targetPath, testTargetInputs, candidateTests, mustRunTests, timeout);
    }

    public static SelectTestsRequest of(String projectCoordinates, String targetPath, TestTargetInputs testTargetInputs, Iterable<? extends ClassNameHash> candidateTests, Iterable<? extends ClassNameHash> mustRunTests, Duration timeout) {
        return ImmutableSelectTestsRequest.validate(new ImmutableSelectTestsRequest(projectCoordinates, targetPath, testTargetInputs, candidateTests, mustRunTests, timeout));
    }

    private static ImmutableSelectTestsRequest validate(ImmutableSelectTestsRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="SelectTestsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROJECT_COORDINATES = 1L;
        private static final long INIT_BIT_TARGET_PATH = 2L;
        private static final long INIT_BIT_TEST_TARGET_INPUTS = 4L;
        private static final long INIT_BIT_TIMEOUT = 8L;
        private long initBits = 15L;
        private String projectCoordinates;
        private String targetPath;
        private TestTargetInputs testTargetInputs;
        private List<ClassNameHash> candidateTests = new ArrayList<ClassNameHash>();
        private List<ClassNameHash> mustRunTests = new ArrayList<ClassNameHash>();
        private Duration timeout;

        private Builder() {
        }

        public final Builder from(SelectTestsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.projectCoordinates(instance.getProjectCoordinates());
            this.targetPath(instance.getTargetPath());
            this.testTargetInputs(instance.getTestTargetInputs());
            this.addAllCandidateTests(instance.getCandidateTests());
            this.addAllMustRunTests(instance.getMustRunTests());
            this.timeout(instance.getTimeout());
            return this;
        }

        @JsonProperty(value="projectCoordinates")
        public final Builder projectCoordinates(String projectCoordinates) {
            this.projectCoordinates = Objects.requireNonNull(projectCoordinates, "projectCoordinates");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="targetPath")
        public final Builder targetPath(String targetPath) {
            this.targetPath = Objects.requireNonNull(targetPath, "targetPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="testTargetInputs")
        public final Builder testTargetInputs(TestTargetInputs testTargetInputs) {
            this.testTargetInputs = Objects.requireNonNull(testTargetInputs, "testTargetInputs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addCandidateTests(ClassNameHash element) {
            this.candidateTests.add(Objects.requireNonNull(element, "candidateTests element"));
            return this;
        }

        public final Builder addCandidateTests(ClassNameHash ... elements) {
            for (ClassNameHash element : elements) {
                this.candidateTests.add(Objects.requireNonNull(element, "candidateTests element"));
            }
            return this;
        }

        @JsonProperty(value="candidateTests")
        public final Builder candidateTests(Iterable<? extends ClassNameHash> elements) {
            this.candidateTests.clear();
            return this.addAllCandidateTests(elements);
        }

        public final Builder addAllCandidateTests(Iterable<? extends ClassNameHash> elements) {
            for (ClassNameHash classNameHash : elements) {
                this.candidateTests.add(Objects.requireNonNull(classNameHash, "candidateTests element"));
            }
            return this;
        }

        public final Builder addMustRunTests(ClassNameHash element) {
            this.mustRunTests.add(Objects.requireNonNull(element, "mustRunTests element"));
            return this;
        }

        public final Builder addMustRunTests(ClassNameHash ... elements) {
            for (ClassNameHash element : elements) {
                this.mustRunTests.add(Objects.requireNonNull(element, "mustRunTests element"));
            }
            return this;
        }

        @JsonProperty(value="mustRunTests")
        public final Builder mustRunTests(Iterable<? extends ClassNameHash> elements) {
            this.mustRunTests.clear();
            return this.addAllMustRunTests(elements);
        }

        public final Builder addAllMustRunTests(Iterable<? extends ClassNameHash> elements) {
            for (ClassNameHash classNameHash : elements) {
                this.mustRunTests.add(Objects.requireNonNull(classNameHash, "mustRunTests element"));
            }
            return this;
        }

        @JsonProperty(value="timeout")
        public final Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public SelectTestsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSelectTestsRequest.validate(new ImmutableSelectTestsRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("projectCoordinates");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetPath");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("testTargetInputs");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timeout");
            }
            return "Cannot build SelectTestsRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SelectTestsRequest", generator="Immutables")
    static final class Json
    implements SelectTestsRequest {
        String projectCoordinates;
        String targetPath;
        TestTargetInputs testTargetInputs;
        Set<ClassNameHash> candidateTests = Collections.emptySet();
        Set<ClassNameHash> mustRunTests = Collections.emptySet();
        Duration timeout;

        Json() {
        }

        @JsonProperty(value="projectCoordinates")
        public void setProjectCoordinates(String projectCoordinates) {
            this.projectCoordinates = projectCoordinates;
        }

        @JsonProperty(value="targetPath")
        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        @JsonProperty(value="testTargetInputs")
        public void setTestTargetInputs(TestTargetInputs testTargetInputs) {
            this.testTargetInputs = testTargetInputs;
        }

        @JsonProperty(value="candidateTests")
        public void setCandidateTests(Set<ClassNameHash> candidateTests) {
            this.candidateTests = candidateTests;
        }

        @JsonProperty(value="mustRunTests")
        public void setMustRunTests(Set<ClassNameHash> mustRunTests) {
            this.mustRunTests = mustRunTests;
        }

        @JsonProperty(value="timeout")
        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Override
        public String getProjectCoordinates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTargetPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TestTargetInputs getTestTargetInputs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ClassNameHash> getCandidateTests() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ClassNameHash> getMustRunTests() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getTimeout() {
            throw new UnsupportedOperationException();
        }
    }
}

