/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.enterprise.b.a;
import com.gradle.enterprise.testselection.common.model.api.v1.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.v1.ImmutableSelectTestsRequest;
import com.gradle.enterprise.testselection.common.model.api.v1.TestTargetInputs;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableSelectTestsRequest.class)
@JsonDeserialize(as=ImmutableSelectTestsRequest.class)
@Value.Immutable
public interface SelectTestsRequest {
    public String getProjectCoordinates();

    public String getTargetPath();

    public TestTargetInputs getTestTargetInputs();

    public Set<ClassNameHash> getCandidateTests();

    public Set<ClassNameHash> getMustRunTests();

    public Duration getTimeout();

    public static SelectTestsRequest create(String projectCoordinates, String targetPath, TestTargetInputs testTargetInputs, Set<ClassNameHash> candidateTests, Set<ClassNameHash> mustRunTests, Duration timeout) {
        return ImmutableSelectTestsRequest.builder().projectCoordinates(projectCoordinates).targetPath(targetPath).testTargetInputs(testTargetInputs).candidateTests(candidateTests).mustRunTests(mustRunTests).timeout(timeout).build();
    }

    @Value.Check
    default public void check() {
        a.a(Collections.disjoint(this.getCandidateTests(), this.getMustRunTests()), () -> "Candidate and must run tests must not overlap");
    }
}

