/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.enterprise.b.a;
import com.gradle.enterprise.testselection.common.model.api.v1.ImmutableSelectTestsResponse;
import com.gradle.enterprise.testselection.common.model.api.v1.NonSelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.ResultType;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.TestClassAndTime;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableSelectTestsResponse.class)
@JsonDeserialize(as=ImmutableSelectTestsResponse.class)
@Value.Immutable
public interface SelectTestsResponse {
    public ResultType getResultType();

    @JsonDeserialize(keyUsing=SelectionReasonIdDeserializer.class)
    public Map<SelectionReasonId, Set<TestClassAndTime>> getSelectedTests();

    @JsonDeserialize(keyUsing=NonSelectionReasonIdDeserializer.class)
    public Map<NonSelectionReasonId, Set<TestClassAndTime>> getNotSelectedTests();

    @JsonDeserialize(keyUsing=SelectionReasonIdDeserializer.class)
    public Map<SelectionReasonId, String> getSelectionReasonDescriptions();

    @JsonDeserialize(keyUsing=NonSelectionReasonIdDeserializer.class)
    public Map<NonSelectionReasonId, String> getNonSelectionReasonDescriptions();

    public static SelectTestsResponse selectTests(Map<SelectionReasonId, Set<TestClassAndTime>> selectedTests, Map<NonSelectionReasonId, Set<TestClassAndTime>> notSelectedTests, Map<SelectionReasonId, String> selectionReasonDescriptions, Map<NonSelectionReasonId, String> nonSelectionReasonDescriptions) {
        a.b(selectionReasonDescriptions.keySet().containsAll(selectedTests.keySet()), () -> "All selection reasons must be present in the descriptions map, missing: " + Sets.difference(selectedTests.keySet(), selectionReasonDescriptions.keySet()));
        a.b(nonSelectionReasonDescriptions.keySet().containsAll(notSelectedTests.keySet()), () -> "All non-selection reasons must be present in the descriptions map, missing: " + Sets.difference(notSelectedTests.keySet(), nonSelectionReasonDescriptions.keySet()));
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.SELECT_TESTS).selectedTests(selectedTests).notSelectedTests(notSelectedTests).selectionReasonDescriptions(selectionReasonDescriptions).nonSelectionReasonDescriptions(nonSelectionReasonDescriptions).build();
    }

    public static SelectTestsResponse withInsufficientData() {
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.INSUFFICIENT_DATA).build();
    }

    public static SelectTestsResponse withProcessingLagging() {
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.PROCESSING_LAGGING).build();
    }

    public static class NonSelectionReasonIdDeserializer
    extends KeyDeserializer {
        @Override
        public Object deserializeKey(String key, DeserializationContext context) {
            return NonSelectionReasonId.of(Integer.parseInt(key));
        }
    }

    public static class SelectionReasonIdDeserializer
    extends KeyDeserializer {
        @Override
        public Object deserializeKey(String key, DeserializationContext context) {
            return SelectionReasonId.of(Integer.parseInt(key));
        }
    }
}

