/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ContentDecoder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ContinueProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.GZIPContentDecoder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpAuthenticationStore;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClientTransport;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProtocolHandlers;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProxyAuthenticationProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.RedirectProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.AuthenticationStore;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpCompliance;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpScheme;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.MappedByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Jetty;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.SocketAddressResolver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.QueuedThreadPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<Origin, HttpDestination> destinations = new ConcurrentHashMap<Origin, HttpDestination>();
    private final ProtocolHandlers handlers = new ProtocolHandlers();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final ProxyConfiguration proxyConfig = new ProxyConfiguration();
    private final HttpClientTransport transport;
    private final SslContextFactory sslContextFactory;
    private AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private CookieManager cookieManager;
    private CookieStore cookieStore;
    private Executor executor;
    private ByteBufferPool byteBufferPool;
    private Scheduler scheduler;
    private SocketAddressResolver resolver;
    private HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private boolean followRedirects = true;
    private int maxConnectionsPerDestination = 64;
    private int maxRequestsQueuedPerDestination = 1024;
    private int requestBufferSize = 4096;
    private int responseBufferSize = 16384;
    private int maxRedirects = 8;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private long addressResolutionTimeout = 15000L;
    private long idleTimeout;
    private boolean tcpNoDelay = true;
    private boolean strictEventOrdering = false;
    private HttpField encodingField;
    private boolean removeIdleDestinations = false;
    private boolean connectBlocking = false;
    private String name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private String defaultRequestContentType = "application/octet-stream";

    public HttpClient() {
        this(new HttpClientTransportOverHTTP(), null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this(new HttpClientTransportOverHTTP(), sslContextFactory);
    }

    public HttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory) {
        this.transport = transport;
        this.addBean(transport);
        this.sslContextFactory = sslContextFactory;
        this.addBean(sslContextFactory);
        this.addBean(this.handlers);
        this.addBean(this.decoderFactories);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new DumpableCollection("requestListeners", this.requestListeners));
    }

    public HttpClientTransport getTransport() {
        return this.transport;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName(this.name);
            this.setExecutor(threadPool);
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool(new MappedByteBufferPool(2048, this.executor instanceof ThreadPool.SizedThreadPool ? ((ThreadPool.SizedThreadPool)this.executor).getMaxThreads() / 2 : ProcessorUtils.availableProcessors() * 2));
        }
        if (this.scheduler == null) {
            this.setScheduler(new ScheduledExecutorScheduler(this.name + "-scheduler", false));
        }
        if (this.resolver == null) {
            this.setSocketAddressResolver(new SocketAddressResolver.Async(this.executor, this.scheduler, this.getAddressResolutionTimeout()));
        }
        this.handlers.put(new ContinueProtocolHandler());
        this.handlers.put(new RedirectProtocolHandler(this));
        this.handlers.put(new WWWAuthenticationProtocolHandler(this));
        this.handlers.put(new ProxyAuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory(this.byteBufferPool));
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        this.transport.setHttpClient(this);
        super.doStart();
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    @Override
    protected void doStop() throws Exception {
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination destination : this.destinations.values()) {
            destination.close();
        }
        this.destinations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public Request POST(URI uri) {
        return this.newRequest(uri).method(HttpMethod.POST);
    }

    public Request newRequest(String host, int port) {
        return this.newRequest(new Origin("http", host, port).asString());
    }

    public Request newRequest(String uri) {
        return this.newRequest(URI.create(uri));
    }

    public Request newRequest(URI uri) {
        return this.newHttpRequest(this.newConversation(), uri);
    }

    protected Request copyRequest(HttpRequest oldRequest, URI newURI) {
        HttpRequest newRequest = this.newHttpRequest(oldRequest.getConversation(), newURI);
        newRequest.method(oldRequest.getMethod()).version(oldRequest.getVersion()).content(oldRequest.getContent()).idleTimeout(oldRequest.getIdleTimeout(), TimeUnit.MILLISECONDS).timeout(oldRequest.getTimeout(), TimeUnit.MILLISECONDS).followRedirects(oldRequest.isFollowRedirects());
        for (HttpField field : oldRequest.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (HttpHeader.HOST == header || HttpHeader.EXPECT == header || HttpHeader.COOKIE == header || HttpHeader.AUTHORIZATION == header || HttpHeader.PROXY_AUTHORIZATION == header) continue;
            String name = field.getName();
            String value = field.getValue();
            if (newRequest.getHeaders().contains(name, value)) continue;
            newRequest.header(name, value);
        }
        return newRequest;
    }

    protected HttpRequest newHttpRequest(HttpConversation conversation, URI uri) {
        return new HttpRequest(this, conversation, this.checkHost(uri));
    }

    private URI checkHost(URI uri) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(String.format("Invalid URI host: null (authority: %s)", uri.getRawAuthority()));
        }
        return uri;
    }

    protected HttpDestination destinationFor(String scheme, String host, int port) {
        return this.resolveDestination(scheme, host, port, null);
    }

    protected HttpDestination resolveDestination(String scheme, String host, int port, Object tag) {
        Origin origin = this.createOrigin(scheme, host, port, tag);
        return this.resolveDestination(origin);
    }

    protected Origin createOrigin(String scheme, String host, int port, Object tag) {
        if (!(HttpScheme.HTTP.is(scheme) || HttpScheme.HTTPS.is(scheme) || HttpScheme.WS.is(scheme) || HttpScheme.WSS.is(scheme))) {
            throw new IllegalArgumentException("Invalid protocol " + scheme);
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        host = host.toLowerCase(Locale.ENGLISH);
        port = HttpClient.normalizePort(scheme, port);
        return new Origin(scheme, host, port, tag);
    }

    public HttpDestination resolveDestination(Origin origin) {
        return this.destinations.computeIfAbsent(origin, o2 -> {
            HttpDestination newDestination = this.getTransport().newHttpDestination((Origin)o2);
            this.addManaged(newDestination);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created {}", newDestination);
            }
            return newDestination;
        });
    }

    protected boolean removeDestination(HttpDestination destination) {
        this.removeBean(destination);
        return this.destinations.remove(destination.getOrigin(), destination);
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        HttpDestination destination = this.resolveDestination(request.getScheme(), request.getHost(), request.getPort(), request.getTag());
        destination.send(request, listeners);
    }

    protected void newConnection(final HttpDestination destination, final Promise<Connection> promise) {
        Origin.Address address = destination.getConnectAddress();
        this.resolver.resolve(address.getHost(), address.getPort(), new Promise<List<InetSocketAddress>>(){

            @Override
            public void succeeded(List<InetSocketAddress> socketAddresses) {
                ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
                context.put("client.connector", HttpClient.this);
                context.put("http.destination", destination);
                this.connect(socketAddresses, 0, context);
            }

            @Override
            public void failed(Throwable x2) {
                promise.failed(x2);
            }

            private void connect(final List<InetSocketAddress> socketAddresses, final int index, final Map<String, Object> context) {
                context.put("http.connection.promise", new Promise.Wrapper<Connection>(promise){

                    @Override
                    public void failed(Throwable x2) {
                        int nextIndex = index + 1;
                        if (nextIndex == socketAddresses.size()) {
                            super.failed(x2);
                        } else {
                            this.connect(socketAddresses, nextIndex, context);
                        }
                    }
                });
                HttpClient.this.transport.connect(socketAddresses.get(index), context);
            }
        });
    }

    private HttpConversation newConversation() {
        return new HttpConversation();
    }

    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        return this.handlers.find(request, response);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        if (this.isStarted()) {
            LOG.warn("Calling setByteBufferPool() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.byteBufferPool, byteBufferPool);
        this.byteBufferPool = byteBufferPool;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getAddressResolutionTimeout() {
        return this.addressResolutionTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isStarted()) {
            LOG.warn("Calling setExecutor() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        if (this.isStarted()) {
            LOG.warn("Calling setScheduler() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public void setSocketAddressResolver(SocketAddressResolver resolver) {
        if (this.isStarted()) {
            LOG.warn("Calling setSocketAddressResolver() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.resolver, resolver);
        this.resolver = resolver;
    }

    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    public void setMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
    }

    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    public void setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    public boolean isRemoveIdleDestinations() {
        return this.removeIdleDestinations;
    }

    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public String getDefaultRequestContentType() {
        return this.defaultRequestContentType;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    public static int normalizePort(String scheme, int port) {
        if (port > 0) {
            return port;
        }
        if (HttpClient.isSchemeSecure(scheme)) {
            return 443;
        }
        return 80;
    }

    public boolean isDefaultPort(String scheme, int port) {
        if (HttpClient.isSchemeSecure(scheme)) {
            return port == 443;
        }
        return port == 80;
    }

    static boolean isSchemeSecure(String scheme) {
        return HttpScheme.HTTPS.is(scheme) || HttpScheme.WSS.is(scheme);
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), connectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(connectionFactory);
        }
        return new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), connectionFactory);
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        @Override
        public boolean add(ContentDecoder.Factory e2) {
            boolean result = this.set.add(e2);
            this.invalidate();
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> c2) {
            boolean result = this.set.addAll(c2);
            this.invalidate();
            return result;
        }

        @Override
        public boolean remove(Object o2) {
            boolean result = this.set.remove(o2);
            this.invalidate();
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            boolean result = this.set.removeAll(c2);
            this.invalidate();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            boolean result = this.set.retainAll(c2);
            this.invalidate();
            return result;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return this.set.contains(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.set.containsAll(c2);
        }

        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            final Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            return new Iterator<ContentDecoder.Factory>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ContentDecoder.Factory next() {
                    return (ContentDecoder.Factory)iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    ContentDecoderFactorySet.this.invalidate();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.set.toArray(a2);
        }

        private void invalidate() {
            if (this.set.isEmpty()) {
                HttpClient.this.encodingField = null;
            } else {
                StringBuilder value = new StringBuilder();
                Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
                while (iterator.hasNext()) {
                    ContentDecoder.Factory decoderFactory = iterator.next();
                    value.append(decoderFactory.getEncoding());
                    if (!iterator.hasNext()) continue;
                    value.append(",");
                }
                HttpClient.this.encodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, value.toString());
            }
        }
    }
}

