/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Request {
    public String getScheme();

    public Request scheme(String var1);

    public String getHost();

    public int getPort();

    public String getMethod();

    public Request method(HttpMethod var1);

    public Request method(String var1);

    public String getPath();

    public Request path(String var1);

    public URI getURI();

    public HttpVersion getVersion();

    public Request version(HttpVersion var1);

    public HttpFields getHeaders();

    public Request header(String var1, String var2);

    public Request header(HttpHeader var1, String var2);

    public List<HttpCookie> getCookies();

    public Request attribute(String var1, Object var2);

    public Map<String, Object> getAttributes();

    public ContentProvider getContent();

    public Request content(ContentProvider var1);

    public Request content(ContentProvider var1, String var2);

    public Request accept(String ... var1);

    public long getIdleTimeout();

    public Request idleTimeout(long var1, TimeUnit var3);

    public Request timeout(long var1, TimeUnit var3);

    public boolean isFollowRedirects();

    public Request followRedirects(boolean var1);

    public <T extends RequestListener> List<T> getRequestListeners(Class<T> var1);

    public Request listener(Listener var1);

    public Request onRequestBegin(BeginListener var1);

    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException;

    public void send(Response.CompleteListener var1);

    public boolean abort(Throwable var1);

    public Throwable getAbortCause();

    public static interface Listener
    extends BeginListener,
    CommitListener,
    ContentListener,
    FailureListener,
    HeadersListener,
    QueuedListener,
    SuccessListener {
        @Override
        default public void onQueued(Request request) {
        }

        @Override
        default public void onBegin(Request request) {
        }

        @Override
        default public void onHeaders(Request request) {
        }

        @Override
        default public void onCommit(Request request) {
        }

        @Override
        default public void onContent(Request request, ByteBuffer content) {
        }

        @Override
        default public void onSuccess(Request request) {
        }

        @Override
        default public void onFailure(Request request, Throwable failure) {
        }
    }

    public static interface FailureListener
    extends RequestListener {
        public void onFailure(Request var1, Throwable var2);
    }

    public static interface SuccessListener
    extends RequestListener {
        public void onSuccess(Request var1);
    }

    public static interface ContentListener
    extends RequestListener {
        public void onContent(Request var1, ByteBuffer var2);
    }

    public static interface CommitListener
    extends RequestListener {
        public void onCommit(Request var1);
    }

    public static interface HeadersListener
    extends RequestListener {
        public void onHeaders(Request var1);
    }

    public static interface BeginListener
    extends RequestListener {
        public void onBegin(Request var1);
    }

    public static interface QueuedListener
    extends RequestListener {
        public void onQueued(Request var1);
    }

    public static interface RequestListener
    extends EventListener {
    }
}

