/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Trie<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;

    private HttpScheme(String s2) {
        this._string = s2;
        this._buffer = BufferUtil.toBuffer(s2);
    }

    public boolean is(String s2) {
        return s2 != null && this._string.equalsIgnoreCase(s2);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    static {
        CACHE = new ArrayTrie<HttpScheme>();
        for (HttpScheme version : HttpScheme.values()) {
            CACHE.put(version.asString(), version);
        }
    }
}

