/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

abstract class AbstractByteBufferPool
implements ByteBufferPool {
    private final int _factor;
    private final int _maxQueueLength;
    private final long _maxHeapMemory;
    private final long _maxDirectMemory;
    private final AtomicLong _heapMemory = new AtomicLong();
    private final AtomicLong _directMemory = new AtomicLong();

    protected AbstractByteBufferPool(int factor, int maxQueueLength, long maxHeapMemory, long maxDirectMemory) {
        this._factor = factor <= 0 ? 1024 : factor;
        this._maxQueueLength = maxQueueLength;
        this._maxHeapMemory = maxHeapMemory != 0L ? maxHeapMemory : Runtime.getRuntime().maxMemory() / 4L;
        this._maxDirectMemory = maxDirectMemory != 0L ? maxDirectMemory : Runtime.getRuntime().maxMemory() / 4L;
    }

    protected int getCapacityFactor() {
        return this._factor;
    }

    protected int getMaxQueueLength() {
        return this._maxQueueLength;
    }

    protected void releaseExcessMemory(boolean direct, Consumer<Boolean> clearFn) {
        long maxMemory;
        long l2 = maxMemory = direct ? this._maxDirectMemory : this._maxHeapMemory;
        if (maxMemory > 0L) {
            while (this.getMemory(direct) > maxMemory) {
                clearFn.accept(direct);
            }
        }
    }

    public long getDirectMemory() {
        return this.getMemory(true);
    }

    public long getHeapMemory() {
        return this.getMemory(false);
    }

    public long getMaxDirectMemory() {
        return this._maxDirectMemory;
    }

    public long getMaxHeapMemory() {
        return this._maxHeapMemory;
    }

    public long getMemory(boolean direct) {
        AtomicLong memory = direct ? this._directMemory : this._heapMemory;
        return memory.get();
    }

    IntConsumer updateMemory(boolean direct) {
        return direct ? this._directMemory::addAndGet : this._heapMemory::addAndGet;
    }
}

