/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class TypeUtil {
    private static final Logger LOG = Log.getLogger(TypeUtil.class);
    public static final Class<?>[] NO_ARGS = new Class[0];
    private static final HashMap<String, Class<?>> name2Class = new HashMap();
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;
    private static final List<Function<Class<?>, URI>> LOCATION_METHODS;
    private static final Function<Class<?>, URI> MODULE_LOCATION;

    public static String toClassReference(Class<?> clazz) {
        return TypeUtil.toClassReference(clazz.getName());
    }

    public static String toClassReference(String className) {
        return StringUtil.replace(className, '.', '/').concat(".class");
    }

    public static int parseInt(String s2, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s2.length() - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(offset + i2);
            int digit = TypeUtil.convertHexDigit((int)c2);
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s2.substring(offset, offset + length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static byte convertHexDigit(byte c2) {
        byte b2 = (byte)((c2 & 0x1F) + (c2 >> 6) * 25 - 16);
        if (b2 < 0 || b2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return b2;
    }

    public static int convertHexDigit(char c2) {
        int d2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (d2 < 0 || d2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return d2;
    }

    public static int convertHexDigit(int c2) {
        int d2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (d2 < 0 || d2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return d2;
    }

    public static void toHex(byte b2, Appendable buf) {
        try {
            int d2 = 0xF & (0xF0 & b2) >> 4;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
            d2 = 0xF & b2;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String toHexString(byte b2) {
        return TypeUtil.toHexString(new byte[]{b2}, 0, 1);
    }

    public static String toHexString(byte[] b2, int offset, int length) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int bi2 = 0xFF & b2[i2];
            int c2 = 48 + bi2 / 16 % 16;
            if (c2 > 57) {
                c2 = 65 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi2 % 16;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static URI getClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, clazz.getClassLoader());
    }

    public static URI getSystemClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, ClassLoader.getSystemClassLoader());
    }

    public static URI getClassLoaderLocation(Class<?> clazz, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        try {
            URL url;
            String resourceName = TypeUtil.toClassReference(clazz);
            if (loader != null && (url = loader.getResource(resourceName)) != null) {
                int idx;
                URI uri = url.toURI();
                String uriStr = uri.toASCIIString();
                if (uriStr.startsWith("jar:file:") && (idx = (uriStr = uriStr.substring(4)).indexOf("!/")) > 0) {
                    return URI.create(uriStr.substring(0, idx));
                }
                return uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getCodeSourceLocation(Class<?> clazz) {
        try {
            URL location;
            CodeSource source;
            ProtectionDomain domain = AccessController.doPrivileged(() -> clazz.getProtectionDomain());
            if (domain != null && (source = domain.getCodeSource()) != null && (location = source.getLocation()) != null) {
                return location.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getModuleLocation(Class<?> clazz) {
        if (MODULE_LOCATION != null) {
            return MODULE_LOCATION.apply(clazz);
        }
        return null;
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] s2 = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", s2));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", s2));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
        LOCATION_METHODS = new ArrayList();
        LOCATION_METHODS.add(TypeUtil::getCodeSourceLocation);
        Function moduleFunc = null;
        try {
            Class<?> clazzModuleLocation = TypeUtil.class.getClassLoader().loadClass(TypeUtil.class.getPackage().getName() + ".ModuleLocation");
            Object obj = clazzModuleLocation.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof Function) {
                moduleFunc = (Function)obj;
                LOCATION_METHODS.add(moduleFunc);
            }
        }
        catch (Throwable t2) {
            LOG.debug("This JVM Runtime does not support Modules, disabling Jetty internal support", new Object[0]);
        }
        MODULE_LOCATION = moduleFunc;
        LOCATION_METHODS.add(TypeUtil::getClassLoaderLocation);
        LOCATION_METHODS.add(TypeUtil::getSystemClassLoaderLocation);
    }
}

