/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponseException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.QuotedStringTokenizer;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.UrlEncoded;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.WebSocketClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.io.UpgradeListener;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.AcceptHash;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.SessionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;

public class WebSocketUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeRequest.class);
    private final WebSocketClient wsClient;
    private final EventDriver localEndpoint;
    private final CompletableFuture<Session> fut;
    private final ClientUpgradeRequestFacade apiRequestFacade = new ClientUpgradeRequestFacade();
    private UpgradeListener upgradeListener;

    public WebSocketUpgradeRequest(WebSocketClient wsClient, HttpClient httpClient, URI wsURI, Object localEndpoint) {
        super(httpClient, new HttpConversation(), wsURI);
        if (!wsURI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be an absolute URI: " + wsURI);
        }
        String scheme = wsURI.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("WebSocket URI must use 'ws' or 'wss' scheme: " + wsURI);
        }
        this.wsClient = wsClient;
        try {
            if (!this.wsClient.isRunning()) {
                this.wsClient.start();
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException("Unable to start WebSocketClient", e2);
        }
        this.localEndpoint = this.wsClient.getEventDriverFactory().wrap(localEndpoint);
        this.fut = new CompletableFuture();
        this.fut.whenComplete((session, throwable) -> {
            if (throwable != null) {
                this.abort((Throwable)throwable);
            }
        });
        this.getConversation().setAttribute(HttpConnectionUpgrader.class.getName(), this);
    }

    private String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    private ExtensionFactory getExtensionFactory() {
        return this.wsClient.getExtensionFactory();
    }

    private SessionFactory getSessionFactory() {
        return this.wsClient.getSessionFactory();
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        this.header(HttpHeader.UPGRADE, "websocket");
        this.header(HttpHeader.CONNECTION, "Upgrade");
        this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        this.header(HttpHeader.PRAGMA, "no-cache");
        this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        if (!this.apiRequestFacade.getExtensions().isEmpty()) {
            for (ExtensionConfig ext : this.apiRequestFacade.getExtensions()) {
                this.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, ext.getParameterizedName());
            }
        }
        if (!this.apiRequestFacade.getSubProtocols().isEmpty()) {
            for (String protocol : this.apiRequestFacade.getSubProtocols()) {
                this.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        }
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeRequest(this.apiRequestFacade);
        }
    }

    @Override
    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", result);
        }
        URI requestURI = result.getRequest().getURI();
        Response response = result.getResponse();
        int responseStatusCode = response.getStatus();
        String responseLine = responseStatusCode + " " + response.getReason();
        if (result.isFailed()) {
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((failure = result.getFailure()) instanceof IOException || failure instanceof UpgradeException) {
                this.handleException(failure);
            } else {
                this.handleException(new UpgradeException(requestURI, responseStatusCode, responseLine, failure));
            }
            return;
        }
        if (responseStatusCode != 101) {
            this.handleException(new UpgradeException(requestURI, responseStatusCode, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + responseLine));
        }
    }

    private void handleException(Throwable failure) {
        try {
            this.localEndpoint.onError(failure);
        }
        catch (Throwable t2) {
            LOG.warn("Exception while notifying onError", t2);
        }
        this.fut.completeExceptionally(failure);
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    @Override
    public void send(Response.CompleteListener listener) {
        this.initWebSocketHeaders();
        super.send(listener);
    }

    public CompletableFuture<Session> sendAsync() {
        this.send(this);
        return this.fut;
    }

    @Override
    public void upgrade(HttpResponse response, HttpConnectionOverHTTP oldConn) {
        String[] extValues;
        String respHash;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", response);
        }
        String reqKey = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String expectedHash = AcceptHash.hashKey(reqKey);
        if (!expectedHash.equalsIgnoreCase(respHash = response.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", response);
        }
        EndPoint endp = oldConn.getEndPoint();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, this.wsClient.getExecutor(), this.wsClient.getScheduler(), this.localEndpoint.getPolicy(), this.wsClient.getBufferPool());
        Collection<Connection.Listener> connectionListeners = this.wsClient.getBeans(Connection.Listener.class);
        if (connectionListeners != null) {
            connectionListeners.forEach(listener -> {
                if (!(listener instanceof WebSocketSession)) {
                    connection.addListener((Connection.Listener)listener);
                }
            });
        }
        URI requestURI = this.getURI();
        ClientUpgradeResponse upgradeResponse = new ClientUpgradeResponse(response);
        WebSocketSession session = this.getSessionFactory().createSession(requestURI, this.localEndpoint, connection);
        session.setUpgradeRequest(new ClientUpgradeRequest(this));
        session.setUpgradeResponse(upgradeResponse);
        connection.addListener(session);
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse(tok.nextToken()));
                }
            }
        }
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        extensionStack.negotiate(extensions);
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        session.addManaged(extensionStack);
        session.setFuture(this.fut);
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeResponse(upgradeResponse);
        }
        endp.upgrade(connection);
    }

    private HttpFields getHttpFields() {
        return super.getHeaders();
    }

    private class ClientUpgradeRequestFacade
    implements UpgradeRequest {
        private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        private List<String> subProtocols = new ArrayList<String>();

        public List<ExtensionConfig> getExtensions() {
            return this.extensions;
        }

        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        @Override
        public Map<String, List<String>> getParameterMap() {
            TreeMap<String, List<String>> paramMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            String query = this.getQueryString();
            MultiMap<String> multimap = new MultiMap<String>();
            UrlEncoded.decodeTo(query, multimap, StandardCharsets.UTF_8);
            paramMap.putAll(multimap);
            return paramMap;
        }

        @Override
        public String getProtocolVersion() {
            String ver = WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.SEC_WEBSOCKET_VERSION);
            if (ver == null) {
                return Integer.toString(13);
            }
            return ver;
        }

        public String getQueryString() {
            return WebSocketUpgradeRequest.this.getURI().getQuery();
        }
    }
}

