/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.ClassWriter;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Opcodes;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompiledExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class SpelCompiler
implements Opcodes {
    private static final Log logger = LogFactory.getLog(SpelCompiler.class);
    private static final Map<ClassLoader, SpelCompiler> compilers = new ConcurrentReferenceHashMap<ClassLoader, SpelCompiler>();
    private volatile ChildClassLoader childClassLoader;
    private final AtomicInteger suffixId = new AtomicInteger(1);

    private SpelCompiler(ClassLoader classloader) {
        this.childClassLoader = new ChildClassLoader(classloader);
    }

    public CompiledExpression compile(SpelNodeImpl expression) {
        if (expression.isCompilable()) {
            Class<? extends CompiledExpression> clazz;
            if (logger.isDebugEnabled()) {
                logger.debug("SpEL: compiling " + expression.toStringAST());
            }
            if ((clazz = this.createExpressionClass(expression)) != null) {
                try {
                    return ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to instantiate CompiledExpression for expression: " + expression.toStringAST(), ex);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SpEL: unable to compile " + expression.toStringAST());
        }
        return null;
    }

    private int getNextSuffix() {
        return this.suffixId.incrementAndGet();
    }

    private Class<? extends CompiledExpression> createExpressionClass(SpelNodeImpl expressionToCompile) {
        String className = "spel/Ex" + this.getNextSuffix();
        String evaluationContextClass = "com/gradle/maven/extension/internal/dep/org/springframework/expression/EvaluationContext";
        ExpressionClassWriter cw2 = new ExpressionClassWriter();
        cw2.visit(52, 1, className, null, "com/gradle/maven/extension/internal/dep/org/springframework/expression/spel/CompiledExpression", null);
        MethodVisitor mv = cw2.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/gradle/maven/extension/internal/dep/org/springframework/expression/spel/CompiledExpression", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw2.visitMethod(1, "getValue", "(Ljava/lang/Object;L" + evaluationContextClass + ";)Ljava/lang/Object;", null, new String[]{"com/gradle/maven/extension/internal/dep/org/springframework/expression/EvaluationException"});
        mv.visitCode();
        CodeFlow cf2 = new CodeFlow(className, cw2);
        try {
            expressionToCompile.generateCode(mv, cf2);
        }
        catch (IllegalStateException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(expressionToCompile.getClass().getSimpleName() + ".generateCode opted out of compilation: " + ex.getMessage());
            }
            return null;
        }
        CodeFlow.insertBoxIfNecessary(mv, cf2.lastDescriptor());
        if ("V".equals(cf2.lastDescriptor())) {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw2.visitEnd();
        cf2.finish();
        byte[] data = cw2.toByteArray();
        return this.loadClass(StringUtils.replace(className, "/", "."), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends CompiledExpression> loadClass(String name, byte[] bytes) {
        ChildClassLoader ccl = this.childClassLoader;
        if (ccl.getClassesDefinedCount() >= 100) {
            SpelCompiler spelCompiler = this;
            synchronized (spelCompiler) {
                ChildClassLoader currentCcl = this.childClassLoader;
                if (ccl == currentCcl) {
                    this.childClassLoader = ccl = new ChildClassLoader(ccl.getParent());
                } else {
                    ccl = currentCcl;
                }
            }
        }
        return ccl.defineClass(name, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpelCompiler getCompiler(ClassLoader classLoader) {
        ClassLoader clToUse = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        SpelCompiler compiler = compilers.get(clToUse);
        if (compiler == null) {
            Map<ClassLoader, SpelCompiler> map = compilers;
            synchronized (map) {
                compiler = compilers.get(clToUse);
                if (compiler == null) {
                    compiler = new SpelCompiler(clToUse);
                    compilers.put(clToUse, compiler);
                }
            }
        }
        return compiler;
    }

    private class ExpressionClassWriter
    extends ClassWriter {
        public ExpressionClassWriter() {
            super(3);
        }

        @Override
        protected ClassLoader getClassLoader() {
            return SpelCompiler.this.childClassLoader;
        }
    }

    private static class ChildClassLoader
    extends URLClassLoader {
        private static final URL[] NO_URLS = new URL[0];
        private final AtomicInteger classesDefinedCount = new AtomicInteger(0);

        public ChildClassLoader(ClassLoader classLoader) {
            super(NO_URLS, classLoader);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            Class<?> clazz = super.defineClass(name, bytes, 0, bytes.length);
            this.classesDefinedCount.incrementAndGet();
            return clazz;
        }

        public int getClassesDefinedCount() {
            return this.classesDefinedCount.get();
        }
    }
}

