/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Expression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompiledExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelCompilerMode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.SpelCompiler;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public class SpelExpression
implements Expression {
    private final String expression;
    private final SpelNodeImpl ast;
    private final SpelParserConfiguration configuration;
    private volatile CompiledExpression compiledAst;
    private final AtomicInteger interpretedCount = new AtomicInteger();
    private final AtomicInteger failedAttempts = new AtomicInteger();

    public SpelExpression(String expression, SpelNodeImpl ast, SpelParserConfiguration configuration) {
        this.expression = expression;
        this.ast = ast;
        this.configuration = configuration;
    }

    @Override
    public Object getValue(EvaluationContext context, Object rootObject) throws EvaluationException {
        Assert.notNull((Object)context, "EvaluationContext is required");
        CompiledExpression compiledAst = this.compiledAst;
        if (compiledAst != null) {
            try {
                return compiledAst.getValue(rootObject, context);
            }
            catch (Throwable ex) {
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                }
                throw new SpelEvaluationException(ex, SpelMessage.EXCEPTION_RUNNING_COMPILED_EXPRESSION, new Object[0]);
            }
        }
        ExpressionState expressionState = new ExpressionState(context, this.toTypedValue(rootObject), this.configuration);
        Object result = this.ast.getValue(expressionState);
        this.checkCompile(expressionState);
        return result;
    }

    @Override
    public <T> T getValue(EvaluationContext context, Object rootObject, Class<T> expectedResultType) throws EvaluationException {
        Assert.notNull((Object)context, "EvaluationContext is required");
        CompiledExpression compiledAst = this.compiledAst;
        if (compiledAst != null) {
            try {
                Object result = compiledAst.getValue(rootObject, context);
                if (expectedResultType != null) {
                    return ExpressionUtils.convertTypedValue(context, new TypedValue(result), expectedResultType);
                }
                return (T)result;
            }
            catch (Throwable ex) {
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                }
                throw new SpelEvaluationException(ex, SpelMessage.EXCEPTION_RUNNING_COMPILED_EXPRESSION, new Object[0]);
            }
        }
        ExpressionState expressionState = new ExpressionState(context, this.toTypedValue(rootObject), this.configuration);
        TypedValue typedResultValue = this.ast.getTypedValue(expressionState);
        this.checkCompile(expressionState);
        return ExpressionUtils.convertTypedValue(context, typedResultValue, expectedResultType);
    }

    private void checkCompile(ExpressionState expressionState) {
        this.interpretedCount.incrementAndGet();
        SpelCompilerMode compilerMode = expressionState.getConfiguration().getCompilerMode();
        if (compilerMode != SpelCompilerMode.OFF) {
            if (compilerMode == SpelCompilerMode.IMMEDIATE) {
                if (this.interpretedCount.get() > 1) {
                    this.compileExpression();
                }
            } else if (this.interpretedCount.get() > 100) {
                this.compileExpression();
            }
        }
    }

    public boolean compileExpression() {
        CompiledExpression compiledAst = this.compiledAst;
        if (compiledAst != null) {
            return true;
        }
        if (this.failedAttempts.get() > 100) {
            return false;
        }
        SpelExpression spelExpression = this;
        synchronized (spelExpression) {
            if (this.compiledAst != null) {
                return true;
            }
            try {
                SpelCompiler compiler = SpelCompiler.getCompiler(this.configuration.getCompilerClassLoader());
                compiledAst = compiler.compile(this.ast);
                if (compiledAst != null) {
                    this.compiledAst = compiledAst;
                    return true;
                }
                this.failedAttempts.incrementAndGet();
                return false;
            }
            catch (Exception ex) {
                this.failedAttempts.incrementAndGet();
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                    return false;
                }
                throw new SpelEvaluationException(ex, SpelMessage.EXCEPTION_COMPILING_EXPRESSION, new Object[0]);
            }
        }
    }

    private TypedValue toTypedValue(Object object) {
        return object != null ? new TypedValue(object) : TypedValue.NULL;
    }
}

