/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandleFactory;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;

public class DefaultBuildCacheController
implements BuildCacheController {
    private final BuildCacheServiceHandle remote;
    private final LocalBuildCacheServiceHandle local;
    private final boolean emitDebugLogging;
    private final BuildCacheTempFileStore tmp;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildCacheServiceHandleFactory handleFactory, Supplier<Path> storageDirectory, boolean logStackTraces, boolean emitDebugLogging) {
        this.emitDebugLogging = emitDebugLogging;
        if (config.local == null) {
            this.local = NullLocalBuildCacheServiceHandle.INSTANCE;
            this.tmp = new DefaultBuildCacheTempFileStore(() -> ((Path)storageDirectory.get()).resolve("build-cache-tmp"));
        } else {
            this.local = handleFactory.toHandle(config.local, config.localPush);
            this.tmp = config.local;
        }
        this.remote = handleFactory.toHandle(config.remote, config.remotePush, BuildCacheServiceRole.REMOTE, logStackTraces);
    }

    @Override
    public <T> Optional<T> load(BuildCacheLoadCommand<T> command) {
        BuildCacheLoadCommand.Result result;
        Unpack unpack = new Unpack(command);
        if (this.local.canLoad()) {
            try {
                this.local.load(command.getKey(), unpack);
            }
            catch (Exception e2) {
                throw new BuildCacheException("Build cache entry " + command.getKey().getHashCode() + " from local build cache is invalid", e2);
            }
            if (unpack.result != null) {
                return Optional.of(unpack.result.getMetadata());
            }
        }
        if (this.remote.canLoad()) {
            this.tmp.withTempFile(command.getKey(), file -> {
                LoadTarget loadTarget = new LoadTarget((File)file);
                if (this.remote.canLoad() && !loadTarget.isLoaded()) {
                    this.remote.load(command.getKey(), loadTarget);
                }
                if (loadTarget.isLoaded()) {
                    try {
                        unpack.accept((File)file);
                    }
                    catch (Exception e2) {
                        String roleDisplayName = BuildCacheServiceRole.REMOTE.getDisplayName();
                        throw new BuildCacheException("Build cache entry " + command.getKey().getHashCode() + " from " + roleDisplayName + " build cache is invalid", e2);
                    }
                    if (this.local.canStore()) {
                        this.local.store(command.getKey(), (File)file);
                    }
                }
            });
        }
        return (result = unpack.result) == null ? Optional.empty() : Optional.of(result.getMetadata());
    }

    @Override
    public void store(BuildCacheStoreCommand command) {
        boolean anyStore;
        boolean bl2 = anyStore = this.local.canStore() || this.remote.canStore();
        if (!anyStore) {
            return;
        }
        BuildCacheKey key = command.getKey();
        Pack pack = new Pack(command);
        this.tmp.withTempFile(command.getKey(), file -> {
            pack.accept((File)file);
            if (this.remote.canStore()) {
                this.remote.store(key, new StoreTarget((File)file));
            }
            if (this.local.canStore()) {
                this.local.store(key, (File)file);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.local.close();
            }
            finally {
                this.remote.close();
            }
        }
    }

    private class Pack
    implements Consumer<File> {
        private final BuildCacheStoreCommand command;

        private Pack(BuildCacheStoreCommand command) {
            this.command = command;
        }

        @Override
        public void accept(File file) {
            try {
                this.command.store(new FileOutputStream(file));
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    private class Unpack<T>
    implements Consumer<File> {
        private final BuildCacheLoadCommand<T> command;
        private BuildCacheLoadCommand.Result<T> result;

        private Unpack(BuildCacheLoadCommand<T> command) {
            this.command = command;
        }

        @Override
        public void accept(File file) {
            try (FileInputStream input = new FileInputStream(file);){
                this.result = this.command.load(input);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }
}

