/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.FieldVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ModuleVisitor;
import java.util.SortedSet;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.ApiMemberWriter;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.SortingAnnotationVisitor;

public class ApiMemberSelector
extends ClassVisitor {
    private final SortedSet<MethodMember> methods = Sets.newTreeSet();
    private final SortedSet<FieldMember> fields = Sets.newTreeSet();
    private final SortedSet<InnerClassMember> innerClasses = Sets.newTreeSet();
    private final String className;
    private final ApiMemberWriter apiMemberWriter;
    private final boolean apiIncludesPackagePrivateMembers;
    private boolean isInnerClass;
    private ClassMember classMember;
    private boolean thisClassIsPrivateInnerClass;

    public ApiMemberSelector(String className, ApiMemberWriter apiMemberWriter, boolean apiIncludesPackagePrivateMembers) {
        super(458752);
        this.className = className;
        this.apiMemberWriter = apiMemberWriter;
        this.apiIncludesPackagePrivateMembers = apiIncludesPackagePrivateMembers;
    }

    public boolean isPrivateInnerClass() {
        return this.thisClassIsPrivateInnerClass;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classMember = new ClassMember(version, access, name, signature, superName, interfaces);
        this.isInnerClass = (access & 0x20) == 32;
    }

    @Override
    public ModuleVisitor visitModule(String name, int access, String version) {
        return this.apiMemberWriter.writeModule(name, access, version);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.apiMemberWriter.writeClass(this.classMember, this.methods, this.fields, this.innerClasses);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationMember ann = new AnnotationMember(desc, visible);
        this.classMember.addAnnotation(ann);
        return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            return null;
        }
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers) || "<init>".equals(name) && this.isInnerClass) {
            final MethodMember methodMember = new MethodMember(access, name, desc, signature, exceptions);
            this.methods.add(methodMember);
            return new MethodVisitor(458752){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    methodMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    ParameterAnnotationMember ann = new ParameterAnnotationMember(desc, visible, parameter);
                    methodMember.addParameterAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitParameterAnnotation(parameter, desc, visible));
                }
            };
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers)) {
            Object keepValue = (access & 8) == 8 && (access & 0x10) == 16 ? value : null;
            final FieldMember fieldMember = new FieldMember(access, name, signature, desc, keepValue);
            this.fields.add(fieldMember);
            return new FieldVisitor(458752){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    fieldMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }
            };
        }
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        boolean privateInnerClass;
        boolean bl2 = privateInnerClass = (access & 2) != 0;
        if (name.equals(this.className) && privateInnerClass) {
            this.thisClassIsPrivateInnerClass = true;
        }
        if (outerName == null || innerName == null || privateInnerClass) {
            return;
        }
        if (!this.apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access)) {
            return;
        }
        this.innerClasses.add(new InnerClassMember(access, name, outerName, innerName));
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public static boolean isCandidateApiMember(int access, boolean apiIncludesPackagePrivateMembers) {
        return ApiMemberSelector.isPublicMember(access) || ApiMemberSelector.isProtectedMember(access) || apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access);
    }

    private static boolean isPublicMember(int access) {
        return (access & 1) == 1;
    }

    private static boolean isProtectedMember(int access) {
        return (access & 4) == 4;
    }

    private static boolean isPackagePrivateMember(int access) {
        return (access & 7) == 0;
    }
}

