/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public abstract class AbstractFileSystemLocationSnapshot
implements FileSystemLocationSnapshot {
    private final String absolutePath;
    private final String name;
    private final FileMetadata.AccessType accessType;

    public AbstractFileSystemLocationSnapshot(String absolutePath, String name, FileMetadata.AccessType accessType) {
        this.absolutePath = absolutePath;
        this.name = name;
        this.accessType = accessType;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FileMetadata.AccessType getAccessType() {
        return this.accessType;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AbstractFileSystemLocationSnapshot that = (AbstractFileSystemLocationSnapshot)o2;
        if (this.accessType != that.accessType) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.absolutePath.equals(that.absolutePath)) {
            return false;
        }
        return this.getHash().equals(that.getHash());
    }

    public int hashCode() {
        int result = this.absolutePath.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.accessType.hashCode();
        result = 31 * result + this.getHash().hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

