/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.stream.Stream;

public interface ChildMap<T> {
    public Stream<Entry<T>> stream();

    public static class Entry<T> {
        private final String path;
        private final T value;

        public Entry(String path, T value) {
            this.path = path;
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Entry entry = (Entry)o2;
            if (!this.path.equals(entry.path)) {
                return false;
            }
            return this.value.equals(entry.value);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{" + this.path + " : " + this.value + '}';
        }
    }
}

