/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.io.File;
import java.util.Comparator;
import org.gradle.internal.snapshot.CaseSensitivity;

public class PathUtil {
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final boolean IS_WINDOWS_SEPARATOR = SYSTEM_SEPARATOR == '\\';
    private static final char OTHER_SEPARATOR = (char)(IS_WINDOWS_SEPARATOR ? 47 : 92);
    private static final Comparator<String> CASE_SENSITIVE_COMPARATOR = (path1, path2) -> PathUtil.comparePaths(path1, path2, CaseSensitivity.CASE_SENSITIVE);
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = (path1, path2) -> PathUtil.comparePaths(path1, path2, CaseSensitivity.CASE_INSENSITIVE);

    public static boolean isFileSeparator(char toCheck) {
        return toCheck == SYSTEM_SEPARATOR || toCheck == OTHER_SEPARATOR;
    }

    public static int compareFileNames(String name1, String name2) {
        int caseInsensitiveComparison = name1.compareToIgnoreCase(name2);
        return caseInsensitiveComparison != 0 ? caseInsensitiveComparison : name1.compareTo(name2);
    }

    static int compareCharsIgnoringCase(char char1, char char2) {
        if (char1 == char2) {
            return 0;
        }
        return PathUtil.isFileSeparator(char1) ? (PathUtil.isFileSeparator(char2) ? 0 : -1) : (PathUtil.isFileSeparator(char2) ? 1 : PathUtil.compareDifferentCharsIgnoringCase(char1, char2));
    }

    private static int compareDifferentCharsIgnoringCase(char char1, char char2) {
        char insensitiveChar2;
        char insensitiveChar1 = Character.toUpperCase(char1);
        if (insensitiveChar1 != (insensitiveChar2 = Character.toUpperCase(char2)) && (insensitiveChar1 = Character.toLowerCase(insensitiveChar1)) != (insensitiveChar2 = Character.toLowerCase(insensitiveChar2))) {
            return Character.compare(insensitiveChar1, insensitiveChar2);
        }
        return 0;
    }

    static int compareChars(char char1, char char2) {
        if (char1 == char2) {
            return 0;
        }
        return PathUtil.isFileSeparator(char1) ? (PathUtil.isFileSeparator(char2) ? 0 : -1) : (PathUtil.isFileSeparator(char2) ? 1 : Character.compare(char1, char2));
    }

    private static int comparePaths(String relativePath1, String relativePath2, CaseSensitivity caseSensitivity) {
        int maxPos = Math.min(relativePath1.length(), relativePath2.length());
        int accumulatedValue = 0;
        for (int pos = 0; pos < maxPos; ++pos) {
            char charInPath2;
            char charInPath1 = relativePath1.charAt(pos);
            int comparedChars = PathUtil.compareCharsIgnoringCase(charInPath1, charInPath2 = relativePath2.charAt(pos));
            if (comparedChars != 0) {
                return comparedChars;
            }
            if ((accumulatedValue = PathUtil.computeCombinedCompare(accumulatedValue, charInPath1, charInPath2, caseSensitivity == CaseSensitivity.CASE_SENSITIVE)) == 0 || !PathUtil.isFileSeparator(charInPath1)) continue;
            return accumulatedValue;
        }
        int lengthCompare = Integer.compare(relativePath1.length(), relativePath2.length());
        return lengthCompare != 0 ? lengthCompare : accumulatedValue;
    }

    private static int computeCombinedCompare(int previousCombinedValue, char charInPath1, char charInPath2, boolean caseSensitive) {
        if (!caseSensitive) {
            return 0;
        }
        return previousCombinedValue == 0 ? PathUtil.compareChars(charInPath1, charInPath2) : previousCombinedValue;
    }

    public static String getFileName(String absolutePath) {
        int lastSeparator = PathUtil.lastIndexOfSeparator(absolutePath);
        return lastSeparator < 0 ? absolutePath : absolutePath.substring(lastSeparator + 1);
    }

    private static int lastIndexOfSeparator(String absolutePath) {
        for (int i2 = absolutePath.length() - 1; i2 >= 0; --i2) {
            char currentChar = absolutePath.charAt(i2);
            if (!PathUtil.isFileSeparator(currentChar)) continue;
            return i2;
        }
        return -1;
    }
}

