/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class FilteredTrackingMerkleDirectorySnapshotBuilder
implements DirectorySnapshotBuilder {
    private final Deque<Boolean> isCurrentLevelUnfiltered = new ArrayDeque<Boolean>();
    private final Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer;
    private final DirectorySnapshotBuilder delegate = MerkleDirectorySnapshotBuilder.sortingRequired();

    public static FilteredTrackingMerkleDirectorySnapshotBuilder sortingRequired(Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer) {
        return new FilteredTrackingMerkleDirectorySnapshotBuilder(unfilteredSnapshotConsumer);
    }

    private FilteredTrackingMerkleDirectorySnapshotBuilder(Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer) {
        this.unfilteredSnapshotConsumer = unfilteredSnapshotConsumer;
        this.isCurrentLevelUnfiltered.addLast(true);
    }

    @Override
    public void enterDirectory(FileMetadata.AccessType accessType, String absolutePath, String name, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
        this.isCurrentLevelUnfiltered.addLast(true);
        this.delegate.enterDirectory(accessType, absolutePath, name, emptyDirectoryHandlingStrategy);
    }

    @Override
    public void visitLeafElement(FileSystemLeafSnapshot snapshot) {
        this.delegate.visitLeafElement(snapshot);
    }

    @Override
    public void visitDirectory(DirectorySnapshot directorySnapshot) {
        this.delegate.visitDirectory(directorySnapshot);
    }

    public void markCurrentLevelAsFiltered() {
        this.isCurrentLevelUnfiltered.removeLast();
        this.isCurrentLevelUnfiltered.addLast(false);
    }

    public boolean isCurrentLevelUnfiltered() {
        return this.isCurrentLevelUnfiltered.getLast();
    }

    @Override
    public FileSystemLocationSnapshot leaveDirectory() {
        FileSystemLocationSnapshot directorySnapshot = this.delegate.leaveDirectory();
        boolean leftLevelUnfiltered = this.isCurrentLevelUnfiltered.removeLast();
        this.isCurrentLevelUnfiltered.addLast(this.isCurrentLevelUnfiltered.removeLast() != false && leftLevelUnfiltered);
        if (!leftLevelUnfiltered && directorySnapshot != null) {
            directorySnapshot.accept(new RootTrackingFileSystemSnapshotHierarchyVisitor(){

                @Override
                public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot, boolean isRoot) {
                    if (isRoot) {
                        return SnapshotVisitResult.CONTINUE;
                    }
                    FilteredTrackingMerkleDirectorySnapshotBuilder.this.unfilteredSnapshotConsumer.accept(snapshot);
                    return SnapshotVisitResult.SKIP_SUBTREE;
                }
            });
        }
        return directorySnapshot;
    }

    @Override
    public FileSystemLocationSnapshot getResult() {
        return this.delegate.getResult();
    }
}

