/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.StringUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldUtils {
    public static Field getField(Class<?> clazz, String string, boolean bl2) {
        AnnotatedElement annotatedElement;
        Validate.notNull(clazz, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(string), "The field name must not be blank/empty", new Object[0]);
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = annotatedElement.getSuperclass()) {
            try {
                Field field = annotatedElement.getDeclaredField(string);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!bl2) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement = null;
        for (Class clazz2 : ClassUtils.getAllInterfaces(clazz)) {
            try {
                Field field = clazz2.getField(string);
                Validate.isTrue(annotatedElement == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", string, clazz);
                annotatedElement = field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement;
    }

    public static Object readField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Validate.notNull(field, "The field must not be null", new Object[0]);
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field.get(object);
    }

    public static Object readField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Validate.notNull(object, "target object must not be null", new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate field %s on %s", string, clazz);
        return FieldUtils.readField(field, object, false);
    }
}

