/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.HeaderDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JWTParser {
    private final ObjectReader payloadReader;
    private final ObjectReader headerReader;

    public JWTParser() {
        this(JWTParser.getDefaultObjectMapper());
    }

    JWTParser(ObjectMapper objectMapper) {
        this.addDeserializers(objectMapper);
        this.payloadReader = objectMapper.readerFor(Payload.class);
        this.headerReader = objectMapper.readerFor(Header.class);
    }

    public Payload parsePayload(String string) throws JWTDecodeException {
        if (string == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Payload)this.payloadReader.readValue(string);
        }
        catch (IOException iOException) {
            throw JWTParser.decodeException(string);
        }
    }

    public Header parseHeader(String string) throws JWTDecodeException {
        if (string == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Header)this.headerReader.readValue(string);
        }
        catch (IOException iOException) {
            throw JWTParser.decodeException(string);
        }
    }

    private void addDeserializers(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        ObjectReader objectReader = objectMapper.reader();
        simpleModule.addDeserializer(Payload.class, new PayloadDeserializer(objectReader));
        simpleModule.addDeserializer(Header.class, new HeaderDeserializer(objectReader));
        objectMapper.registerModule(simpleModule);
    }

    static ObjectMapper getDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return objectMapper;
    }

    private static JWTDecodeException decodeException() {
        return JWTParser.decodeException(null);
    }

    private static JWTDecodeException decodeException(String string) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", string));
    }
}

