/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BinaryNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BooleanNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.DecimalNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.DoubleNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.FloatNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.IntNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.LongNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.MissingNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.NullNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.NumericNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.POJONode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.TextNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ValueNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements Serializable {
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bl2) {
        this._cfgBigDecimalExact = bl2;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public BooleanNode booleanNode(boolean bl2) {
        return bl2 ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public JsonNode missingNode() {
        return MissingNode.getInstance();
    }

    public NumericNode numberNode(int n2) {
        return IntNode.valueOf(n2);
    }

    public NumericNode numberNode(long l2) {
        return LongNode.valueOf(l2);
    }

    public ValueNode numberNode(BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.nullNode();
        }
        return BigIntegerNode.valueOf(bigInteger);
    }

    public NumericNode numberNode(float f2) {
        return FloatNode.valueOf(f2);
    }

    public NumericNode numberNode(double d2) {
        return DoubleNode.valueOf(d2);
    }

    public ValueNode numberNode(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.nullNode();
        }
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        if (bigDecimal.signum() == 0) {
            return DecimalNode.ZERO;
        }
        try {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return DecimalNode.valueOf(bigDecimal);
    }

    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    public ValueNode rawValueNode(RawValue rawValue) {
        return new POJONode(rawValue);
    }
}

