/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectSpliterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Collections2;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SetMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(K k2) {
        return this.createCollection();
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean put(K k2, V v2) {
        Collection<V> collection = this.map.get(k2);
        if (collection == null) {
            collection = this.createCollection(k2);
            if (collection.add(v2)) {
                ++this.totalSize;
                this.map.put(k2, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(v2)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(K k2) {
        Collection<V> collection = this.map.get(k2);
        if (collection == null) {
            collection = this.createCollection(k2);
        }
        return this.wrapCollection(k2, collection);
    }

    Collection<V> wrapCollection(K k2, Collection<V> collection) {
        return new WrappedCollection(k2, collection, null);
    }

    final List<V> wrapList(K k2, List<V> list, WrappedCollection wrappedCollection) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(this, k2, list, wrappedCollection) : new WrappedList(k2, list, wrappedCollection);
    }

    private static <E> Iterator<E> iteratorOrListIterator(Collection<E> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    Set<K> createKeySet() {
        return new KeySet(this.map);
    }

    final Set<K> createMaybeNavigableKeySet() {
        if (this.map instanceof NavigableMap) {
            return new NavigableKeySet((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedKeySet((SortedMap)this.map);
        }
        return new KeySet(this.map);
    }

    private void removeValuesForKey(Object object) {
        Collection<V> collection = Maps.safeRemove(this.map, object);
        if (collection != null) {
            int n2 = collection.size();
            collection.clear();
            this.totalSize -= n2;
        }
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new AbstractMultimap.EntrySet(this);
        }
        return new AbstractMultimap.Entries(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr(this){

            Map.Entry<K, V> output(K k2, V v2) {
                return Maps.immutableEntry(k2, v2);
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(this.map.entrySet().spliterator(), entry -> {
            Object k2 = entry.getKey();
            Collection collection = (Collection)entry.getValue();
            return CollectSpliterators.map(collection.spliterator(), object2 -> Maps.immutableEntry(k2, object2));
        }, 64, this.size());
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this.map);
    }

    final Map<K, Collection<V>> createMaybeNavigableAsMap() {
        if (this.map instanceof NavigableMap) {
            return new NavigableAsMap((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedAsMap((SortedMap)this.map);
        }
        return new AsMap(this.map);
    }

    class NavigableAsMap
    extends SortedAsMap
    implements NavigableMap {
        NavigableAsMap(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        public Map.Entry<K, Collection<V>> lowerEntry(K k2) {
            Map.Entry entry = this.sortedMap().lowerEntry(k2);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K lowerKey(K k2) {
            return this.sortedMap().lowerKey(k2);
        }

        public Map.Entry<K, Collection<V>> floorEntry(K k2) {
            Map.Entry entry = this.sortedMap().floorEntry(k2);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K floorKey(K k2) {
            return this.sortedMap().floorKey(k2);
        }

        public Map.Entry<K, Collection<V>> ceilingEntry(K k2) {
            Map.Entry entry = this.sortedMap().ceilingEntry(k2);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K ceilingKey(K k2) {
            return this.sortedMap().ceilingKey(k2);
        }

        public Map.Entry<K, Collection<V>> higherEntry(K k2) {
            Map.Entry entry = this.sortedMap().higherEntry(k2);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K higherKey(K k2) {
            return this.sortedMap().higherKey(k2);
        }

        @Override
        public Map.Entry<K, Collection<V>> firstEntry() {
            Map.Entry entry = this.sortedMap().firstEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public Map.Entry<K, Collection<V>> lastEntry() {
            Map.Entry entry = this.sortedMap().lastEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public Map.Entry<K, Collection<V>> pollFirstEntry() {
            return this.pollAsMapEntry(this.entrySet().iterator());
        }

        @Override
        public Map.Entry<K, Collection<V>> pollLastEntry() {
            return this.pollAsMapEntry(this.descendingMap().entrySet().iterator());
        }

        Map.Entry<K, Collection<V>> pollAsMapEntry(Iterator<Map.Entry<K, Collection<V>>> iterator) {
            if (!iterator.hasNext()) {
                return null;
            }
            Map.Entry entry = iterator.next();
            Collection collection = AbstractMapBasedMultimap.this.createCollection();
            collection.addAll(entry.getValue());
            iterator.remove();
            return Maps.immutableEntry(entry.getKey(), AbstractMapBasedMultimap.this.unmodifiableCollectionSubclass(collection));
        }

        public NavigableMap<K, Collection<V>> descendingMap() {
            return new NavigableAsMap(this.sortedMap().descendingMap());
        }

        @Override
        public NavigableSet<K> keySet() {
            return (NavigableSet)super.keySet();
        }

        @Override
        NavigableSet<K> createKeySet() {
            return new NavigableKeySet(this.sortedMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(K k2, K k3) {
            return this.subMap(k2, true, k3, false);
        }

        public NavigableMap<K, Collection<V>> subMap(K k2, boolean bl2, K k3, boolean bl3) {
            return new NavigableAsMap(this.sortedMap().subMap(k2, bl2, k3, bl3));
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(K k2) {
            return this.headMap(k2, false);
        }

        public NavigableMap<K, Collection<V>> headMap(K k2, boolean bl2) {
            return new NavigableAsMap(this.sortedMap().headMap(k2, bl2));
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(K k2) {
            return this.tailMap(k2, true);
        }

        public NavigableMap<K, Collection<V>> tailMap(K k2, boolean bl2) {
            return new NavigableAsMap(this.sortedMap().tailMap(k2, bl2));
        }
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap {
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        public SortedMap<K, Collection<V>> headMap(K k2) {
            return new SortedAsMap(this.sortedMap().headMap(k2));
        }

        public SortedMap<K, Collection<V>> subMap(K k2, K k3) {
            return new SortedAsMap(this.sortedMap().subMap(k2, k3));
        }

        public SortedMap<K, Collection<V>> tailMap(K k2) {
            return new SortedAsMap(this.sortedMap().tailMap(k2));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedSet sortedSet = this.sortedKeySet;
            return sortedSet == null ? (this.sortedKeySet = this.createKeySet()) : sortedSet;
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet(this.sortedMap());
        }
    }

    private class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        AsMap(Map<K, Collection<V>> map) {
            this.submap = map;
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries();
        }

        @Override
        public boolean containsKey(Object object) {
            return Maps.safeContainsKey(this.submap, object);
        }

        @Override
        public Collection<V> get(Object object) {
            Collection collection = Maps.safeGet(this.submap, object);
            if (collection == null) {
                return null;
            }
            Object object2 = object;
            return AbstractMapBasedMultimap.this.wrapCollection(object2, collection);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        @Override
        public Collection<V> remove(Object object) {
            Collection collection = this.submap.remove(object);
            if (collection == null) {
                return null;
            }
            Collection collection2 = AbstractMapBasedMultimap.this.createCollection();
            collection2.addAll(collection);
            AbstractMapBasedMultimap.this.totalSize -= collection.size();
            collection.clear();
            return collection2;
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.submap.equals(object);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
            } else {
                Iterators.clear(new AsMapIterator());
            }
        }

        Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            Object k2 = entry.getKey();
            return Maps.immutableEntry(k2, AbstractMapBasedMultimap.this.wrapCollection(k2, entry.getValue()));
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            Collection<V> collection;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                this.collection = entry.getValue();
                return AsMap.this.wrapEntry(entry);
            }

            @Override
            public void remove() {
                CollectPreconditions.checkRemove(this.collection != null);
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
                this.collection = null;
            }
        }

        class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            AsMapEntries() {
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            public Spliterator<Map.Entry<K, Collection<V>>> spliterator() {
                return CollectSpliterators.map(AsMap.this.submap.entrySet().spliterator(), AsMap.this::wrapEntry);
            }

            @Override
            public boolean contains(Object object) {
                return Collections2.safeContains(AsMap.this.submap.entrySet(), object);
            }

            @Override
            public boolean remove(Object object) {
                if (!this.contains(object)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                AbstractMapBasedMultimap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        Itr() {
            this.keyIterator = AbstractMapBasedMultimap.this.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        abstract T output(K var1, V var2);

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                Map.Entry entry = this.keyIterator.next();
                this.key = entry.getKey();
                this.collection = entry.getValue();
                this.valueIterator = this.collection.iterator();
            }
            return this.output(this.key, this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMapBasedMultimap.this.totalSize--;
        }
    }

    class NavigableKeySet
    extends SortedKeySet
    implements NavigableSet {
        NavigableKeySet(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        public K lower(K k2) {
            return this.sortedMap().lowerKey(k2);
        }

        public K floor(K k2) {
            return this.sortedMap().floorKey(k2);
        }

        public K ceiling(K k2) {
            return this.sortedMap().ceilingKey(k2);
        }

        public K higher(K k2) {
            return this.sortedMap().higherKey(k2);
        }

        public K pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        public K pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        public NavigableSet<K> descendingSet() {
            return new NavigableKeySet(this.sortedMap().descendingMap());
        }

        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> headSet(K k2) {
            return this.headSet((K)k2, false);
        }

        public NavigableSet<K> headSet(K k2, boolean bl2) {
            return new NavigableKeySet(this.sortedMap().headMap(k2, bl2));
        }

        @Override
        public NavigableSet<K> subSet(K k2, K k3) {
            return this.subSet((K)k2, true, (K)k3, false);
        }

        public NavigableSet<K> subSet(K k2, boolean bl2, K k3, boolean bl3) {
            return new NavigableKeySet(this.sortedMap().subMap(k2, bl2, k3, bl3));
        }

        @Override
        public NavigableSet<K> tailSet(K k2) {
            return this.tailSet((K)k2, true);
        }

        public NavigableSet<K> tailSet(K k2, boolean bl2) {
            return new NavigableKeySet(this.sortedMap().tailMap(k2, bl2));
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet {
        SortedKeySet(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)super.map();
        }

        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        public K first() {
            return this.sortedMap().firstKey();
        }

        public SortedSet<K> headSet(K k2) {
            return new SortedKeySet(this.sortedMap().headMap(k2));
        }

        public K last() {
            return this.sortedMap().lastKey();
        }

        public SortedSet<K> subSet(K k2, K k3) {
            return new SortedKeySet(this.sortedMap().subMap(k2, k3));
        }

        public SortedSet<K> tailSet(K k2) {
            return new SortedKeySet(this.sortedMap().tailMap(k2));
        }
    }

    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        KeySet(Map<K, Collection<V>> map) {
            super(map);
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator iterator = this.map().entrySet().iterator();
            return new Iterator<K>(){
                Map.Entry<K, Collection<V>> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)iterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    CollectPreconditions.checkRemove(this.entry != null);
                    Collection collection = this.entry.getValue();
                    iterator.remove();
                    AbstractMapBasedMultimap.this.totalSize -= collection.size();
                    collection.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return this.map().keySet().spliterator();
        }

        @Override
        public boolean remove(Object object) {
            int n2 = 0;
            Collection collection = (Collection)this.map().remove(object);
            if (collection != null) {
                n2 = collection.size();
                collection.clear();
                AbstractMapBasedMultimap.this.totalSize -= n2;
            }
            return n2 > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.map().keySet().containsAll(collection);
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.map().keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(AbstractMapBasedMultimap abstractMapBasedMultimap, K k2, List<V> list, WrappedCollection wrappedCollection) {
            super(k2, list, wrappedCollection);
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List {
        WrappedList(K k2, List<V> list, WrappedCollection wrappedCollection) {
            super(k2, list, wrappedCollection);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        public boolean addAll(int n2, Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n3 = this.size();
            boolean bl2 = this.getListDelegate().addAll(n2, collection);
            if (bl2) {
                int n4 = this.getDelegate().size();
                AbstractMapBasedMultimap.this.totalSize += n4 - n3;
                if (n3 == 0) {
                    this.addToMap();
                }
            }
            return bl2;
        }

        public V get(int n2) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(n2);
        }

        public V set(int n2, V v2) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(n2, v2);
        }

        public void add(int n2, V v2) {
            this.refreshIfEmpty();
            boolean bl2 = this.getDelegate().isEmpty();
            this.getListDelegate().add(n2, v2);
            AbstractMapBasedMultimap.this.totalSize++;
            if (bl2) {
                this.addToMap();
            }
        }

        public V remove(int n2) {
            this.refreshIfEmpty();
            Object v2 = this.getListDelegate().remove(n2);
            AbstractMapBasedMultimap.this.totalSize--;
            this.removeIfEmpty();
            return v2;
        }

        @Override
        public int indexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(object);
        }

        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        public ListIterator<V> listIterator(int n2) {
            this.refreshIfEmpty();
            return new WrappedListIterator(n2);
        }

        public List<V> subList(int n2, int n3) {
            this.refreshIfEmpty();
            return AbstractMapBasedMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList(n2, n3), this.getAncestor() == null ? this : this.getAncestor());
        }

        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int n2) {
                super(WrappedList.this.getListDelegate().listIterator(n2));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(V v2) {
                this.getDelegateListIterator().set(v2);
            }

            public void add(V v2) {
                boolean bl2 = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(v2);
                AbstractMapBasedMultimap.this.totalSize++;
                if (bl2) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    class WrappedNavigableSet
    extends WrappedSortedSet
    implements NavigableSet {
        WrappedNavigableSet(K k2, NavigableSet<V> navigableSet, WrappedCollection wrappedCollection) {
            super(k2, navigableSet, wrappedCollection);
        }

        NavigableSet<V> getSortedSetDelegate() {
            return (NavigableSet)super.getSortedSetDelegate();
        }

        public V lower(V v2) {
            return this.getSortedSetDelegate().lower(v2);
        }

        public V floor(V v2) {
            return this.getSortedSetDelegate().floor(v2);
        }

        public V ceiling(V v2) {
            return this.getSortedSetDelegate().ceiling(v2);
        }

        public V higher(V v2) {
            return this.getSortedSetDelegate().higher(v2);
        }

        public V pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        public V pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        private NavigableSet<V> wrap(NavigableSet<V> navigableSet) {
            return new WrappedNavigableSet(this.key, navigableSet, this.getAncestor() == null ? this : this.getAncestor());
        }

        public NavigableSet<V> descendingSet() {
            return this.wrap(this.getSortedSetDelegate().descendingSet());
        }

        public Iterator<V> descendingIterator() {
            return new WrappedCollection.WrappedIterator(this.getSortedSetDelegate().descendingIterator());
        }

        public NavigableSet<V> subSet(V v2, boolean bl2, V v3, boolean bl3) {
            return this.wrap(this.getSortedSetDelegate().subSet(v2, bl2, v3, bl3));
        }

        public NavigableSet<V> headSet(V v2, boolean bl2) {
            return this.wrap(this.getSortedSetDelegate().headSet(v2, bl2));
        }

        public NavigableSet<V> tailSet(V v2, boolean bl2) {
            return this.wrap(this.getSortedSetDelegate().tailSet(v2, bl2));
        }
    }

    class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet {
        WrappedSortedSet(K k2, SortedSet<V> sortedSet, WrappedCollection wrappedCollection) {
            super(k2, sortedSet, wrappedCollection);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        public SortedSet<V> headSet(V v2) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(v2), this.getAncestor() == null ? this : this.getAncestor());
        }

        public SortedSet<V> subSet(V v2, V v3) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(v2, v3), this.getAncestor() == null ? this : this.getAncestor());
        }

        public SortedSet<V> tailSet(V v2) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(v2), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    class WrappedSet
    extends WrappedCollection
    implements Set {
        WrappedSet(K k2, Set<V> set) {
            super(k2, set, null);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl2 = Sets.removeAllImpl((Set)this.delegate, collection);
            if (bl2) {
                int n3 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n3 - n2;
                this.removeIfEmpty();
            }
            return bl2;
        }
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        final Collection<V> ancestorDelegate;

        WrappedCollection(K k2, Collection<V> collection, WrappedCollection wrappedCollection) {
            this.key = k2;
            this.delegate = collection;
            this.ancestor = wrappedCollection;
            this.ancestorDelegate = wrappedCollection == null ? null : wrappedCollection.getDelegate();
        }

        void refreshIfEmpty() {
            Collection collection;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (collection = (Collection)AbstractMapBasedMultimap.this.map.get(this.key)) != null) {
                this.delegate = collection;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                AbstractMapBasedMultimap.this.map.remove(this.key);
            }
        }

        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                AbstractMapBasedMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            this.refreshIfEmpty();
            return this.delegate.spliterator();
        }

        @Override
        public boolean add(V v2) {
            this.refreshIfEmpty();
            boolean bl2 = this.delegate.isEmpty();
            boolean bl3 = this.delegate.add(v2);
            if (bl3) {
                AbstractMapBasedMultimap.this.totalSize++;
                if (bl2) {
                    this.addToMap();
                }
            }
            return bl3;
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl2 = this.delegate.addAll(collection);
            if (bl2) {
                int n3 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n3 - n2;
                if (n2 == 0) {
                    this.addToMap();
                }
            }
            return bl2;
        }

        @Override
        public boolean contains(Object object) {
            this.refreshIfEmpty();
            return this.delegate.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(collection);
        }

        @Override
        public void clear() {
            int n2 = this.size();
            if (n2 == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.this.totalSize -= n2;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object object) {
            this.refreshIfEmpty();
            boolean bl2 = this.delegate.remove(object);
            if (bl2) {
                AbstractMapBasedMultimap.this.totalSize--;
                this.removeIfEmpty();
            }
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl2 = this.delegate.removeAll(collection);
            if (bl2) {
                int n3 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n3 - n2;
                this.removeIfEmpty();
            }
            return bl2;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            int n2 = this.size();
            boolean bl2 = this.delegate.retainAll(collection);
            if (bl2) {
                int n3 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n3 - n2;
                this.removeIfEmpty();
            }
            return bl2;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> iterator) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = iterator;
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize--;
                WrappedCollection.this.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }
}

