/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.internal;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.RetryPolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.EventHandler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.RetryPolicyImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.RandomDelay;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.SyncExecutionInternal;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class RetryPolicyExecutor<R>
extends PolicyExecutor<R> {
    private final RetryPolicyImpl<R> retryPolicy;
    private final RetryPolicyConfig<R> config;
    private volatile int failedAttempts;
    private volatile boolean retriesExceeded;
    private volatile long lastDelayNanos;
    private final EventHandler<R> abortHandler;
    private final EventHandler<R> failedAttemptHandler;
    private final EventHandler<R> retriesExceededHandler;
    private final EventHandler<R> retryHandler;
    private final EventHandler<R> retryScheduledHandler;

    public RetryPolicyExecutor(RetryPolicyImpl<R> retryPolicyImpl, int n2) {
        super(retryPolicyImpl, n2);
        this.retryPolicy = retryPolicyImpl;
        this.config = retryPolicyImpl.getConfig();
        this.abortHandler = EventHandler.ofExecutionCompleted(this.config.getAbortListener());
        this.failedAttemptHandler = EventHandler.ofExecutionAttempted(this.config.getFailedAttemptListener());
        this.retriesExceededHandler = EventHandler.ofExecutionCompleted(this.config.getRetriesExceededListener());
        this.retryHandler = EventHandler.ofExecutionAttempted(this.config.getRetryListener());
        this.retryScheduledHandler = EventHandler.ofExecutionScheduled(this.config.getRetryScheduledListener());
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> function, Scheduler scheduler) {
        return syncExecutionInternal -> {
            while (true) {
                ExecutionResult executionResult = (ExecutionResult)function.apply((SyncExecutionInternal<R>)syncExecutionInternal);
                if (this.retriesExceeded || syncExecutionInternal.isCancelled(this)) {
                    return executionResult;
                }
                if ((executionResult = this.postExecute(syncExecutionInternal, executionResult)).isComplete() || syncExecutionInternal.isCancelled(this)) {
                    return executionResult;
                }
                try {
                    if (this.retryScheduledHandler != null) {
                        this.retryScheduledHandler.handle(executionResult, syncExecutionInternal);
                    }
                    syncExecutionInternal.setInterruptable(true);
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(executionResult.getDelay()));
                }
                catch (InterruptedException interruptedException) {
                    if (!syncExecutionInternal.isInterrupted()) {
                        Thread.currentThread().interrupt();
                    }
                    ExecutionResult executionResult2 = ExecutionResult.exception(interruptedException);
                    return executionResult2;
                }
                finally {
                    syncExecutionInternal.setInterruptable(false);
                }
                Object object = syncExecutionInternal.getLock();
                synchronized (object) {
                    if (syncExecutionInternal.isCancelled(this)) {
                        return executionResult;
                    }
                    syncExecutionInternal = syncExecutionInternal.copy();
                }
                if (this.retryHandler == null) continue;
                this.retryHandler.handle(executionResult, syncExecutionInternal);
            }
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        return asyncExecutionInternal -> {
            CompletableFuture<ExecutionResult<R>> completableFuture = new CompletableFuture<ExecutionResult<R>>();
            AtomicReference<ExecutionResult<R>> atomicReference = new AtomicReference<ExecutionResult<R>>();
            try {
                this.handleAsync((AsyncExecutionInternal<R>)asyncExecutionInternal, function, scheduler, failsafeFuture, completableFuture, atomicReference);
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
            return completableFuture;
        };
    }

    public Object handleAsync(AsyncExecutionInternal<R> asyncExecutionInternal, Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture, CompletableFuture<ExecutionResult<R>> completableFuture, AtomicReference<ExecutionResult<R>> atomicReference) {
        ExecutionResult<R> executionResult2 = atomicReference.get();
        if (this.retryHandler != null && !asyncExecutionInternal.isRecorded() && executionResult2 != null) {
            this.retryHandler.handle(executionResult2, asyncExecutionInternal);
        }
        function.apply(asyncExecutionInternal).whenComplete((executionResult, throwable2) -> {
            if (this.isValidResult((ExecutionResult<R>)executionResult, (Throwable)throwable2, completableFuture)) {
                if (this.retriesExceeded || asyncExecutionInternal.isCancelled(this)) {
                    completableFuture.complete((ExecutionResult<R>)executionResult);
                } else {
                    this.postExecuteAsync(asyncExecutionInternal, executionResult, scheduler, failsafeFuture).whenComplete((executionResult2, throwable) -> {
                        if (this.isValidResult((ExecutionResult<R>)executionResult2, (Throwable)throwable, completableFuture)) {
                            FailsafeFuture failsafeFuture2 = failsafeFuture;
                            synchronized (failsafeFuture2) {
                                if (executionResult2.isComplete() || asyncExecutionInternal.isCancelled(this)) {
                                    completableFuture.complete((ExecutionResult<R>)executionResult2);
                                } else if (!failsafeFuture.isDone()) {
                                    try {
                                        if (this.retryScheduledHandler != null) {
                                            this.retryScheduledHandler.handle((ExecutionResult<R>)executionResult2, asyncExecutionInternal);
                                        }
                                        atomicReference.set((ExecutionResult<R>)executionResult2);
                                        AsyncExecutionInternal asyncExecutionInternal2 = asyncExecutionInternal.copy();
                                        failsafeFuture.setExecution(asyncExecutionInternal2);
                                        Callable<Object> callable = () -> this.handleAsync(asyncExecutionInternal2, function, scheduler, failsafeFuture, completableFuture, atomicReference);
                                        ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, executionResult2.getDelay(), TimeUnit.NANOSECONDS);
                                        failsafeFuture.cancelDependencies(this, false, null);
                                        failsafeFuture.setCancelFn(-1, (bl2, executionResult) -> scheduledFuture.cancel((boolean)bl2));
                                        failsafeFuture.setCancelFn(this, (bl2, executionResult) -> completableFuture.complete((ExecutionResult)executionResult));
                                    }
                                    catch (Throwable throwable2) {
                                        completableFuture.completeExceptionally(throwable2);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
        return null;
    }

    boolean isValidResult(ExecutionResult<R> executionResult, Throwable throwable, CompletableFuture<ExecutionResult<R>> completableFuture) {
        if (throwable != null) {
            completableFuture.completeExceptionally(throwable);
            return false;
        }
        if (executionResult == null) {
            completableFuture.complete(null);
            return false;
        }
        return true;
    }

    @Override
    public ExecutionResult<R> onFailure(ExecutionContext<R> executionContext, ExecutionResult<R> executionResult) {
        boolean bl2;
        if (this.failedAttemptHandler != null) {
            this.failedAttemptHandler.handle(executionResult, executionContext);
        }
        ++this.failedAttempts;
        long l2 = this.lastDelayNanos;
        Duration duration = this.retryPolicy.computeDelay(executionContext);
        if (duration != null) {
            l2 = duration.toNanos();
        } else {
            l2 = this.getFixedOrRandomDelayNanos(l2);
            this.lastDelayNanos = l2 = this.adjustForBackoff(executionContext, l2);
        }
        if (l2 != 0L) {
            l2 = this.adjustForJitter(l2);
        }
        long l3 = executionContext.getElapsedTime().toNanos();
        l2 = this.adjustForMaxDuration(l2, l3);
        boolean bl3 = this.config.getMaxRetries() != -1 && this.failedAttempts > this.config.getMaxRetries();
        boolean bl4 = this.config.getMaxDuration() != null && l3 > this.config.getMaxDuration().toNanos();
        this.retriesExceeded = bl3 || bl4;
        boolean bl5 = this.retryPolicy.isAbortable(executionResult.getResult(), executionResult.getException());
        boolean bl6 = !executionResult.isSuccess() && !bl5 && !this.retriesExceeded && this.config.allowsRetries();
        boolean bl7 = bl5 || !bl6;
        boolean bl8 = bl2 = bl7 && executionResult.isSuccess() && !bl5;
        if (this.abortHandler != null && bl5) {
            this.abortHandler.handle(executionResult, executionContext);
        } else if (this.retriesExceededHandler != null && !bl2 && this.retriesExceeded) {
            this.retriesExceededHandler.handle(executionResult, executionContext);
        }
        return executionResult.with(l2, bl7, bl2);
    }

    @Override
    public CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> executionContext, ExecutionResult<R> executionResult, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        return super.onFailureAsync(executionContext, executionResult.withNotComplete(), scheduler, failsafeFuture);
    }

    private long getFixedOrRandomDelayNanos(long l2) {
        Duration duration = this.config.getDelay();
        Duration duration2 = this.config.getDelayMin();
        Duration duration3 = this.config.getDelayMax();
        if (l2 == 0L && duration != null && !duration.equals(Duration.ZERO)) {
            l2 = duration.toNanos();
        } else if (duration2 != null && duration3 != null) {
            l2 = RandomDelay.randomDelayInRange(duration2.toNanos(), duration3.toNanos(), Math.random());
        }
        return l2;
    }

    private long adjustForBackoff(ExecutionContext<R> executionContext, long l2) {
        if (executionContext.getAttemptCount() != 1 && this.config.getMaxDelay() != null) {
            l2 = (long)Math.min((double)l2 * this.config.getDelayFactor(), (double)this.config.getMaxDelay().toNanos());
        }
        return l2;
    }

    private long adjustForJitter(long l2) {
        if (this.config.getJitter() != null) {
            l2 = RandomDelay.randomDelay(l2, this.config.getJitter().toNanos(), Math.random());
        } else if (this.config.getJitterFactor() > 0.0) {
            l2 = RandomDelay.randomDelay(l2, this.config.getJitterFactor(), Math.random());
        }
        return l2;
    }

    private long adjustForMaxDuration(long l2, long l3) {
        long l4;
        if (this.config.getMaxDuration() != null && (l2 = Math.min(l2, (l4 = this.config.getMaxDuration().toNanos() - l3) < 0L ? 0L : l4)) < 0L) {
            l2 = 0L;
        }
        return l2;
    }
}

