/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectCollectors;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ObjectArrays;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SortedIterable;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SortedIterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collector;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    final transient Comparator<? super E> comparator;
    transient ImmutableSortedSet<E> descendingSet;

    public static <E> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        return CollectCollectors.toImmutableSortedSet(comparator);
    }

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> collection) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Object object;
        Preconditions.checkNotNull(comparator);
        boolean bl2 = SortedIterables.hasSameComparator(comparator, iterable);
        if (bl2 && iterable instanceof ImmutableSortedSet && !((ImmutableCollection)(object = (ImmutableSortedSet)iterable)).isPartialView()) {
            return object;
        }
        object = Iterables.toArray(iterable);
        return ImmutableSortedSet.construct(comparator, ((Object[])object).length, object);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> collection) {
        return ImmutableSortedSet.copyOf(comparator, collection);
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n2, E ... EArray) {
        if (n2 == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull((Object[])EArray, n2);
        Arrays.sort(EArray, 0, n2, comparator);
        int n3 = 1;
        for (int i2 = 1; i2 < n2; ++i2) {
            E e2 = EArray[i2];
            E e3 = EArray[n3 - 1];
            if (comparator.compare(e2, e3) == 0) continue;
            EArray[n3++] = e2;
        }
        Arrays.fill(EArray, n3, n2, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(EArray, n3), comparator);
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E e2) {
        return this.headSet((Object)e2, false);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e2, boolean bl2) {
        return this.headSetImpl(Preconditions.checkNotNull(e2), bl2);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e2, E e3) {
        return this.subSet((Object)e2, true, (Object)e3, false);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
        Preconditions.checkNotNull(e2);
        Preconditions.checkNotNull(e3);
        Preconditions.checkArgument(this.comparator.compare(e2, e3) <= 0);
        return this.subSetImpl(e2, bl2, e3, bl3);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e2) {
        return this.tailSet((Object)e2, true);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e2, boolean bl2) {
        return this.tailSetImpl(Preconditions.checkNotNull(e2), bl2);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    public E lower(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, false)).descendingIterator(), null);
    }

    @Override
    public E floor(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, true)).descendingIterator(), null);
    }

    @Override
    public E ceiling(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, true), null);
    }

    @Override
    public E higher(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> immutableSortedSet = this.descendingSet;
        if (immutableSortedSet == null) {
            immutableSortedSet = this.descendingSet = this.createDescendingSet();
            immutableSortedSet.descendingSet = this;
        }
        return immutableSortedSet;
    }

    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            {
                this.iterator = ImmutableSortedSet.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> consumer) {
                if (this.iterator.hasNext()) {
                    consumer.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return ImmutableSortedSet.this.comparator;
            }
        };
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(Object var1);

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new Object[4];
            this.n = 0;
        }

        @Override
        void copy() {
            this.elements = Arrays.copyOf(this.elements, this.elements.length);
        }

        private void sortAndDedup() {
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, 0, this.n, this.comparator);
            int n2 = 1;
            for (int i2 = 1; i2 < this.n; ++i2) {
                int n3 = this.comparator.compare(this.elements[n2 - 1], this.elements[i2]);
                if (n3 < 0) {
                    this.elements[n2++] = this.elements[i2];
                    continue;
                }
                if (n3 <= 0) continue;
                String string = String.valueOf(this.comparator);
                throw new AssertionError((Object)new StringBuilder(48 + String.valueOf(string).length()).append("Comparator ").append(string).append(" compare method violates its contract").toString());
            }
            Arrays.fill(this.elements, n2, this.n, null);
            this.n = n2;
        }

        @Override
        public Builder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int n2 = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (n2 > this.elements.length) {
                    this.elements = Arrays.copyOf(this.elements, n2);
                }
            }
            this.elements[this.n++] = e2;
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder builder2 = (Builder)builder;
            for (int i2 = 0; i2 < builder2.n; ++i2) {
                this.add((Object)builder2.elements[i2]);
            }
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

