/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.message;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.NullByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.SuspendToken;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final ByteBuffer EOF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final Session session;
    private final ByteBufferPool bufferPool;
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private final long timeoutMs;
    private ByteBuffer activeBuffer = null;
    private SuspendToken suspendToken;
    private State state = State.RESUMED;

    public MessageInputStream(Session session) {
        this(session, -1);
    }

    public MessageInputStream(Session session, int n2) {
        this.timeoutMs = n2;
        this.session = session;
        this.bufferPool = session instanceof WebSocketSession ? ((WebSocketSession)session).getBufferPool() : new NullByteBufferPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendFrame(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        boolean bl3;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending {} chunk: {}", bl2 ? "final" : "non-final", BufferUtil.toDetailString(byteBuffer));
        }
        if ((bl3 = BufferUtil.isEmpty(byteBuffer)) && !bl2) {
            return;
        }
        try {
            MessageInputStream messageInputStream = this;
            synchronized (messageInputStream) {
                if (!bl3) {
                    switch (this.state) {
                        case CLOSED: {
                            return;
                        }
                        case RESUMED: {
                            this.suspendToken = this.session.suspend();
                            this.state = State.SUSPENDED;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Incorrect State: " + this.state.name());
                        }
                    }
                    ByteBuffer byteBuffer2 = this.acquire(byteBuffer.remaining(), byteBuffer.isDirect());
                    BufferUtil.clearToFill(byteBuffer2);
                    byteBuffer2.put(byteBuffer);
                    BufferUtil.flipToFlush(byteBuffer2, 0);
                    this.buffers.put(byteBuffer2);
                }
                if (bl2) {
                    this.buffers.add(EOF);
                    this.state = State.COMPLETE;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MessageInputStream messageInputStream = this;
        synchronized (messageInputStream) {
            boolean bl2;
            if (this.state == State.CLOSED) {
                return;
            }
            boolean bl3 = bl2 = this.state != State.COMPLETE || !this.buffers.isEmpty() && this.buffers.peek() != EOF || this.activeBuffer != null && this.activeBuffer.hasRemaining();
            if (bl2) {
                LOG.warn("MessageInputStream closed without fully consuming content {}", this.session);
            }
            if (this.activeBuffer != null && this.activeBuffer != EOF) {
                this.bufferPool.release(this.activeBuffer);
            }
            for (ByteBuffer byteBuffer : this.buffers) {
                if (byteBuffer == null || byteBuffer == EOF) continue;
                this.bufferPool.release(byteBuffer);
            }
            this.activeBuffer = null;
            this.buffers.clear();
            this.state = State.CLOSED;
            this.buffers.add(EOF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerComplete() {
        SuspendToken suspendToken;
        this.close();
        MessageInputStream messageInputStream = this;
        synchronized (messageInputStream) {
            suspendToken = this.suspendToken;
            this.suspendToken = null;
        }
        if (suspendToken != null) {
            suspendToken.resume();
        }
    }

    @Override
    public int read() throws IOException {
        int n2;
        byte[] byArray = new byte[1];
        do {
            if ((n2 = this.read(byArray, 0, 1)) >= 0) continue;
            return -1;
        } while (n2 == 0);
        return byArray[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            if (this.state == State.CLOSED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stream closed", new Object[0]);
                }
                return -1;
            }
            while (this.activeBuffer == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting {} ms to read", this.timeoutMs);
                }
                if (this.timeoutMs < 0L) {
                    this.activeBuffer = this.buffers.take();
                } else {
                    this.activeBuffer = this.buffers.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                    if (this.activeBuffer == null) {
                        throw new IOException(String.format("Read timeout: %,dms expired", this.timeoutMs));
                    }
                }
                if (this.activeBuffer != EOF) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reached EOF", new Object[0]);
                }
                this.close();
                return -1;
            }
            ByteBuffer byteBuffer = BufferUtil.toBuffer(byArray, n2, n3);
            BufferUtil.clearToFill(byteBuffer);
            int n4 = BufferUtil.put(this.activeBuffer, byteBuffer);
            BufferUtil.flipToFlush(byteBuffer, 0);
            if (!this.activeBuffer.hasRemaining()) {
                SuspendToken suspendToken = null;
                MessageInputStream messageInputStream = this;
                synchronized (messageInputStream) {
                    if (this.activeBuffer != null && this.activeBuffer != EOF) {
                        this.bufferPool.release(this.activeBuffer);
                    }
                    this.activeBuffer = null;
                    switch (this.state) {
                        case CLOSED: {
                            return -1;
                        }
                        case COMPLETE: {
                            break;
                        }
                        case SUSPENDED: {
                            suspendToken = this.suspendToken;
                            this.suspendToken = null;
                            this.state = State.RESUMED;
                            break;
                        }
                        case RESUMED: {
                            throw new IllegalStateException("Incorrect State: " + this.state.name());
                        }
                    }
                }
                if (suspendToken != null) {
                    suspendToken.resume();
                }
            }
            return n4;
        }
        catch (InterruptedException interruptedException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupted while waiting to read", interruptedException);
            }
            this.close();
            return -1;
        }
    }

    @Override
    public void messageComplete() {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void mark(int n2) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private ByteBuffer acquire(int n2, boolean bl2) {
        return this.bufferPool.acquire(n2, bl2);
    }

    private static enum State {
        RESUMED,
        SUSPENDED,
        COMPLETE,
        CLOSED;

    }
}

