/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.FieldVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ModuleVisitor;
import java.util.Set;
import org.gradle.internal.normalization.java.impl.AnnotationAnnotationValue;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.EnumAnnotationValue;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;

public class ApiMemberWriter {
    private final ClassVisitor apiMemberAdapter;

    public ApiMemberWriter(ClassVisitor classVisitor) {
        this.apiMemberAdapter = classVisitor;
    }

    public ModuleVisitor writeModule(String string, int n2, String string2) {
        return this.apiMemberAdapter.visitModule(string, n2, string2);
    }

    public void writeClass(ClassMember classMember, Set<MethodMember> set, Set<FieldMember> set2, Set<InnerClassMember> set3) {
        this.apiMemberAdapter.visit(classMember.getVersion(), classMember.getAccess(), classMember.getName(), classMember.getSignature(), classMember.getSuperName(), classMember.getInterfaces());
        this.writeClassAnnotations(classMember.getAnnotations());
        for (String object : classMember.getPermittedSubclasses()) {
            this.apiMemberAdapter.visitPermittedSubclass(object);
        }
        for (MethodMember methodMember : set) {
            this.writeMethod(methodMember);
        }
        for (FieldMember fieldMember : set2) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(fieldMember.getAccess(), fieldMember.getName(), fieldMember.getTypeDesc(), fieldMember.getSignature(), fieldMember.getValue());
            this.writeFieldAnnotations(fieldVisitor, fieldMember.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClassMember : set3) {
            this.apiMemberAdapter.visitInnerClass(innerClassMember.getName(), innerClassMember.getOuterName(), innerClassMember.getInnerName(), innerClassMember.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    protected void writeMethod(MethodMember methodMember) {
        MethodVisitor methodVisitor = this.apiMemberAdapter.visitMethod(methodMember.getAccess(), methodMember.getName(), methodMember.getTypeDesc(), methodMember.getSignature(), methodMember.getExceptions().toArray(new String[0]));
        this.writeMethodAnnotations(methodVisitor, methodMember.getAnnotations());
        this.writeMethodAnnotations(methodVisitor, methodMember.getParameterAnnotations());
        methodVisitor.visitEnd();
    }

    protected void writeClassAnnotations(Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    private void writeMethodAnnotations(MethodVisitor methodVisitor, Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = annotationMember instanceof ParameterAnnotationMember ? methodVisitor.visitParameterAnnotation(((ParameterAnnotationMember)annotationMember).getParameter(), annotationMember.getName(), annotationMember.isVisible()) : methodVisitor.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    private void writeFieldAnnotations(FieldVisitor fieldVisitor, Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    private void writeAnnotationValues(AnnotationMember annotationMember, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotationMember.getValues()) {
            this.writeAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    private void writeAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> annotationValue) {
        String string = annotationValue.getName();
        if (annotationValue instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(string, ((EnumAnnotationValue)annotationValue).getTypeDesc(), (String)annotationValue.getValue());
        } else if (annotationValue instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(string, annotationValue.getValue());
        } else if (annotationValue instanceof ArrayAnnotationValue) {
            AnnotationValue[] annotationValueArray;
            AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string);
            for (AnnotationValue annotationValue2 : annotationValueArray = (AnnotationValue[])((ArrayAnnotationValue)annotationValue).getValue()) {
                this.writeAnnotationValue(annotationVisitor2, annotationValue2);
            }
            annotationVisitor2.visitEnd();
        } else if (annotationValue instanceof AnnotationAnnotationValue) {
            AnnotationMember annotationMember = (AnnotationMember)((AnnotationAnnotationValue)annotationValue).getValue();
            AnnotationVisitor annotationVisitor3 = annotationVisitor.visitAnnotation(string, annotationMember.getName());
            this.writeAnnotationValues(annotationMember, annotationVisitor3);
        }
    }
}

