package com.gradle.maven.extension.api.cache;

/**
 * Configures the credentials when accessing the remote build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code gradle-enterprise.xml}.
 *
 * @since 1.6.5
 */
public interface Credentials {

    /**
     * Gets the remote build cache username.
     *
     * @return the remote build cache username
     * @since 1.6.5
     */
    String getUsername();

    /**
     * Sets the remote build cache username.
     * <p>
     * Configuration via the {@code gradle.cache.remote.username} system property will always take precedence.
     *
     * @param username the remote build cache username
     * @since 1.6.5
     */
    void setUsername(String username);

    /**
     * Gets the remote build cache password.
     *
     * @return the remote build cache password
     * @since 1.6.5
     */
    String getPassword();

    /**
     * Sets the remote build cache password.
     * <p>
     * Configuration via the {@code gradle.cache.remote.password} system property will always take precedence.
     *
     * @param password the remote build cache password
     * @since 1.6.5
     */
    void setPassword(String password);

}
