/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ThreadLocalBufferManager {
    private final Object RELEASE_LOCK = new Object();
    private final Map<SoftReference<BufferRecycler>, Boolean> _trackedRecyclers = new ConcurrentHashMap<SoftReference<BufferRecycler>, Boolean>();
    private final ReferenceQueue<BufferRecycler> _refQueue = new ReferenceQueue();

    ThreadLocalBufferManager() {
    }

    public static ThreadLocalBufferManager instance() {
        return ThreadLocalBufferManagerHolder.manager;
    }

    public SoftReference<BufferRecycler> wrapAndTrack(BufferRecycler bufferRecycler) {
        SoftReference<BufferRecycler> softReference = new SoftReference<BufferRecycler>(bufferRecycler, this._refQueue);
        this._trackedRecyclers.put(softReference, true);
        this.removeSoftRefsClearedByGc();
        return softReference;
    }

    private void removeSoftRefsClearedByGc() {
        SoftReference softReference;
        while ((softReference = (SoftReference)this._refQueue.poll()) != null) {
            this._trackedRecyclers.remove(softReference);
        }
    }

    private static final class ThreadLocalBufferManagerHolder {
        static final ThreadLocalBufferManager manager = new ThreadLocalBufferManager();
    }
}

