/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.reflect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;

public abstract class Invokable<T, R>
implements AnnotatedElement,
Member {
    private final AccessibleObject accessibleObject;
    private final Member member;

    <M extends AccessibleObject> Invokable(M m2) {
        Preconditions.checkNotNull(m2);
        this.accessibleObject = m2;
        this.member = (Member)((Object)m2);
    }

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.accessibleObject.isAnnotationPresent(clazz);
    }

    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.accessibleObject.getAnnotation(clazz);
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.accessibleObject.getAnnotations();
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.accessibleObject.getDeclaredAnnotations();
    }

    @Override
    public final String getName() {
        return this.member.getName();
    }

    @Override
    public final int getModifiers() {
        return this.member.getModifiers();
    }

    @Override
    public final boolean isSynthetic() {
        return this.member.isSynthetic();
    }

    public boolean equals(Object object) {
        if (object instanceof Invokable) {
            Invokable invokable = (Invokable)object;
            return this.getOwnerType().equals(invokable.getOwnerType()) && this.member.equals(invokable.member);
        }
        return false;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }

    public final Class<? super T> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    abstract Type[] getGenericParameterTypes();

    static class ConstructorInvokable<T>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
        }

        @Override
        Type[] getGenericParameterTypes() {
            Class<?>[] classArray;
            Type[] typeArray = this.constructor.getGenericParameterTypes();
            if (typeArray.length > 0 && this.mayNeedHiddenThis() && typeArray.length == (classArray = this.constructor.getParameterTypes()).length && classArray[0] == this.getDeclaringClass().getEnclosingClass()) {
                return Arrays.copyOfRange(typeArray, 1, typeArray.length);
            }
            return typeArray;
        }

        private boolean mayNeedHiddenThis() {
            Class<?> clazz = this.constructor.getDeclaringClass();
            if (clazz.getEnclosingConstructor() != null) {
                return true;
            }
            Method method = clazz.getEnclosingMethod();
            if (method != null) {
                return !Modifier.isStatic(method.getModifiers());
            }
            return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
        }
    }

    static class MethodInvokable<T>
    extends Invokable<T, Object> {
        final Method method;

        MethodInvokable(Method method) {
            super(method);
            this.method = method;
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }
    }
}

