/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JavaModuleDescriptor {
    private String name;
    private boolean automatic;
    private Set<JavaRequires> requires = new LinkedHashSet<JavaRequires>();
    private Set<JavaExports> exports = new LinkedHashSet<JavaExports>();
    private Set<String> uses = new LinkedHashSet<String>();
    private Set<JavaProvides> provides = new LinkedHashSet<JavaProvides>();

    public String name() {
        return this.name;
    }

    public Set<JavaRequires> requires() {
        return Collections.unmodifiableSet(this.requires);
    }

    public Set<JavaProvides> provides() {
        return Collections.unmodifiableSet(this.provides);
    }

    public Set<String> uses() {
        return Collections.unmodifiableSet(this.uses);
    }

    public static Builder newModule(String string) {
        return new Builder(string).setAutomatic(false);
    }

    public static Builder newAutomaticModule(String string) {
        return new Builder(string).setAutomatic(true);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.automatic, this.requires, this.exports);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaModuleDescriptor javaModuleDescriptor = (JavaModuleDescriptor)object;
        if (this.automatic != javaModuleDescriptor.automatic) {
            return false;
        }
        if (!Objects.equals(this.name, javaModuleDescriptor.name)) {
            return false;
        }
        if (!Objects.equals(this.requires, javaModuleDescriptor.requires)) {
            return false;
        }
        return Objects.equals(this.exports, javaModuleDescriptor.exports);
    }

    public String toString() {
        return "JavaModuleDescriptor{name='" + this.name + '\'' + ", automatic=" + this.automatic + ", requires=" + this.requires + ", exports=" + this.exports + ", uses=" + this.uses + ", provides=" + this.provides + '}';
    }

    public static class JavaProvides {
        private final String service;
        private final List<String> providers;

        private JavaProvides(String string, List<String> list) {
            this.service = string;
            this.providers = list;
        }

        public String service() {
            return this.service;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.providers);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JavaProvides javaProvides = (JavaProvides)object;
            if (!Objects.equals(this.service, javaProvides.service)) {
                return false;
            }
            return Objects.equals(this.providers, javaProvides.providers);
        }

        public String toString() {
            return "JavaProvides{service='" + this.service + '\'' + ", providers=" + this.providers + '}';
        }
    }

    public static class JavaExports {
        private final String source;
        private final Set<String> targets;

        private JavaExports(String string) {
            this.source = string;
            this.targets = null;
        }

        public JavaExports(String string, Set<String> set) {
            this.source = string;
            this.targets = set;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.targets);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JavaExports javaExports = (JavaExports)object;
            if (!Objects.equals(this.source, javaExports.source)) {
                return false;
            }
            return Objects.equals(this.targets, javaExports.targets);
        }

        public String toString() {
            return "JavaExports{source='" + this.source + '\'' + ", targets=" + this.targets + '}';
        }
    }

    public static class JavaRequires {
        private final Set<JavaModifier> modifiers;
        private final String name;

        private JavaRequires(Set<JavaModifier> set, String string) {
            this.modifiers = set;
            this.name = string;
        }

        private JavaRequires(String string) {
            this.modifiers = Collections.emptySet();
            this.name = string;
        }

        public Set<JavaModifier> modifiers() {
            return this.modifiers;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.modifiers, this.name);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JavaRequires javaRequires = (JavaRequires)object;
            if (!Objects.equals(this.modifiers, javaRequires.modifiers)) {
                return false;
            }
            return Objects.equals(this.name, javaRequires.name);
        }

        public String toString() {
            return "JavaRequires{modifiers=" + this.modifiers + ", name='" + this.name + '\'' + '}';
        }

        public static enum JavaModifier {
            STATIC,
            TRANSITIVE;

        }
    }

    public static final class Builder {
        private JavaModuleDescriptor jModule = new JavaModuleDescriptor();

        private Builder(String string) {
            this.jModule.name = string;
        }

        private Builder setAutomatic(boolean bl2) {
            this.jModule.automatic = bl2;
            return this;
        }

        public Builder requires(Set<JavaRequires.JavaModifier> set, String string) {
            this.jModule.requires.add(new JavaRequires(set, string));
            return this;
        }

        public Builder requires(String string) {
            this.jModule.requires.add(new JavaRequires(string));
            return this;
        }

        public Builder exports(String string) {
            this.jModule.exports.add(new JavaExports(string));
            return this;
        }

        public Builder exports(String string, Set<String> set) {
            this.jModule.exports.add(new JavaExports(string, set));
            return this;
        }

        public Builder uses(String string) {
            this.jModule.uses.add(string);
            return this;
        }

        public Builder provides(String string, List<String> list) {
            this.jModule.provides.add(new JavaProvides(string, list));
            return this;
        }

        public JavaModuleDescriptor build() {
            return this.jModule;
        }
    }
}

