/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.io.IoFunction;

abstract class AbstractZipEntry
implements ZipEntry {
    private final java.util.zip.ZipEntry entry;

    public AbstractZipEntry(java.util.zip.ZipEntry zipEntry) {
        this.entry = zipEntry;
    }

    protected java.util.zip.ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public int size() {
        return (int)this.entry.getSize();
    }

    @Override
    public byte[] getContent() throws IOException {
        return this.withInputStream(new IoFunction<InputStream, byte[]>(){

            @Override
            public byte[] apply(InputStream inputStream) throws IOException {
                int n2 = AbstractZipEntry.this.size();
                if (n2 >= 0) {
                    byte[] byArray = new byte[n2];
                    ByteStreams.readFully(inputStream, byArray);
                    return byArray;
                }
                return ByteStreams.toByteArray(inputStream);
            }
        });
    }
}

