/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.output;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.AbstractByteArrayOutputStream;

public final class UnsynchronizedByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public UnsynchronizedByteArrayOutputStream() {
        this(1024);
    }

    public UnsynchronizedByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.needNewBuffer(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("offset=%,d, length=%,d", n2, n3));
        }
        if (n3 == 0) {
            return;
        }
        this.writeImpl(byArray, n2, n3);
    }

    @Override
    public void write(int n2) {
        this.writeImpl(n2);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArrayImpl();
    }
}

