/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.NoHttpResponseException;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.HttpRequestRetryHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.NonRepeatableRequestException;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.CloseableHttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpExecutionAware;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpRequestWrapper;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.ClientExecChain;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.RequestEntityProxy;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.io.IOException;

public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain clientExecChain, HttpRequestRetryHandler httpRequestRetryHandler) {
        Args.notNull(clientExecChain, "HTTP request executor");
        Args.notNull(httpRequestRetryHandler, "HTTP request retry handler");
        this.requestExecutor = clientExecChain;
        this.retryHandler = httpRequestRetryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n2 = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            catch (IOException iOException) {
                if (httpExecutionAware != null && httpExecutionAware.isAborted()) {
                    this.log.debug("Request has been aborted");
                    throw iOException;
                }
                if (this.retryHandler.retryRequest(iOException, n2, httpClientContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + iOException.getClass().getName() + ") caught when processing request to " + httpRoute + ": " + iOException.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException.getMessage(), iOException);
                    }
                    if (!RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                        this.log.debug("Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", iOException);
                    }
                    httpRequestWrapper.setHeaders(headerArray);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Retrying request to " + httpRoute);
                    }
                } else {
                    if (iOException instanceof NoHttpResponseException) {
                        NoHttpResponseException noHttpResponseException = new NoHttpResponseException(httpRoute.getTargetHost().toHostString() + " failed to respond");
                        noHttpResponseException.setStackTrace(iOException.getStackTrace());
                        throw noHttpResponseException;
                    }
                    throw iOException;
                }
                ++n2;
                continue;
            }
            break;
        }
    }
}

