/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectionHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringJoiner;

public class FunctionReference
extends SpelNodeImpl {
    private final String name;
    private volatile Method method;

    public FunctionReference(String string, int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.name = string;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        TypedValue typedValue = expressionState.lookupVariable(this.name);
        if (typedValue == TypedValue.NULL) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_NOT_DEFINED, this.name);
        }
        if (!(typedValue.getValue() instanceof Method)) {
            throw new SpelEvaluationException(SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, this.name, typedValue.getClass());
        }
        try {
            return this.executeFunctionJLRMethod(expressionState, (Method)typedValue.getValue());
        }
        catch (SpelEvaluationException spelEvaluationException) {
            spelEvaluationException.setPosition(this.getStartPosition());
            throw spelEvaluationException;
        }
    }

    private TypedValue executeFunctionJLRMethod(ExpressionState expressionState, Method method) throws EvaluationException {
        int n2;
        Object[] objectArray = this.getArguments(expressionState);
        if (!method.isVarArgs() && (n2 = method.getParameterCount()) != objectArray.length) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, objectArray.length, n2);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_MUST_BE_STATIC, ClassUtils.getQualifiedMethodName(method), this.name);
        }
        TypeConverter typeConverter = expressionState.getEvaluationContext().getTypeConverter();
        boolean bl2 = ReflectionHelper.convertAllArguments(typeConverter, objectArray, method);
        if (method.isVarArgs()) {
            objectArray = ReflectionHelper.setupArgumentsForVarargsInvocation(method.getParameterTypes(), objectArray);
        }
        boolean bl3 = false;
        try {
            ReflectionUtils.makeAccessible(method);
            Object object = method.invoke(method.getClass(), objectArray);
            bl3 = !bl2;
            TypedValue typedValue = new TypedValue(object, new TypeDescriptor(new MethodParameter(method, -1)).narrow(object));
            return typedValue;
        }
        catch (Exception exception) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)exception, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, exception.getMessage());
        }
        finally {
            if (bl3) {
                this.exitTypeDescriptor = CodeFlow.toDescriptor(method.getReturnType());
                this.method = method;
            } else {
                this.exitTypeDescriptor = null;
                this.method = null;
            }
        }
    }

    @Override
    public String toStringAST() {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            stringJoiner.add(this.getChild(i2).toStringAST());
        }
        return '#' + this.name + stringJoiner.toString();
    }

    private Object[] getArguments(ExpressionState expressionState) throws EvaluationException {
        Object[] objectArray = new Object[this.getChildCount()];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = this.children[i2].getValueInternal(expressionState).getValue();
        }
        return objectArray;
    }

    @Override
    public boolean isCompilable() {
        Method method = this.method;
        if (method == null) {
            return false;
        }
        int n2 = method.getModifiers();
        if (!(Modifier.isStatic(n2) && Modifier.isPublic(n2) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
            return false;
        }
        for (SpelNodeImpl spelNodeImpl : this.children) {
            if (spelNodeImpl.isCompilable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        Method method = this.method;
        Assert.state(method != null, "No method handle");
        String string = method.getDeclaringClass().getName().replace('.', '/');
        FunctionReference.generateCodeForArguments(methodVisitor, codeFlow, method, this.children);
        methodVisitor.visitMethodInsn(184, string, method.getName(), CodeFlow.createSignatureDescriptor(method), false);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

