/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.internal.file.archive.ZipEntry;

class JdkZipEntry
implements ZipEntry {
    private final java.util.zip.ZipEntry entry;
    private final Supplier<InputStream> inputStreamSupplier;
    private final Runnable closeAction;

    public JdkZipEntry(java.util.zip.ZipEntry zipEntry, Supplier<InputStream> supplier, Runnable runnable) {
        this.entry = zipEntry;
        this.inputStreamSupplier = supplier;
        this.closeAction = runnable;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public byte[] getContent() throws IOException {
        return this.withInputStream(new ZipEntry.InputStreamAction<byte[]>(){

            @Override
            public byte[] run(InputStream inputStream) throws IOException {
                int n2 = JdkZipEntry.this.size();
                if (n2 >= 0) {
                    byte[] byArray = new byte[n2];
                    ByteStreams.readFully(inputStream, byArray);
                    return byArray;
                }
                return ByteStreams.toByteArray(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withInputStream(ZipEntry.InputStreamAction<T> inputStreamAction) throws IOException {
        InputStream inputStream = this.inputStreamSupplier.get();
        try {
            T t2 = inputStreamAction.run(inputStream);
            return t2;
        }
        finally {
            if (this.closeAction != null) {
                this.closeAction.run();
            } else {
                inputStream.close();
            }
        }
    }

    public int size() {
        return (int)this.entry.getSize();
    }
}

