/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class IgnoredPathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final IgnoredPathFingerprintingStrategy DEFAULT = new IgnoredPathFingerprintingStrategy();
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public IgnoredPathFingerprintingStrategy(FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        super("IGNORED_PATH", fileSystemLocationSnapshotHasher);
        this.normalizedContentHasher = fileSystemLocationSnapshotHasher;
    }

    private IgnoredPathFingerprintingStrategy() {
        this(FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet hashSet = new HashSet();
        fileSystemSnapshot.accept(fileSystemLocationSnapshot -> {
            fileSystemLocationSnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitRegularFile(RegularFileSnapshot regularFileSnapshot) {
                    this.visitNonDirectoryEntry(fileSystemLocationSnapshot);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingFileSnapshot) {
                    this.visitNonDirectoryEntry(fileSystemLocationSnapshot);
                }

                private void visitNonDirectoryEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot2) {
                    HashCode hashCode;
                    String string = fileSystemLocationSnapshot2.getAbsolutePath();
                    if (hashSet.add(string) && (hashCode = IgnoredPathFingerprintingStrategy.this.getNormalizedContentHash(fileSystemLocationSnapshot2, IgnoredPathFingerprintingStrategy.this.normalizedContentHasher)) != null) {
                        builder.put(string, IgnoredPathFileSystemLocationFingerprint.create(fileSystemLocationSnapshot2.getType(), hashCode));
                    }
                }
            });
            return SnapshotVisitResult.CONTINUE;
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

