/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOExceptionList;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeletingPathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.StandardDeleteOption;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;

public final class PathUtils {
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    public static Counters.PathCounters delete(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        return Files.isDirectory(path, linkOptionArray) ? PathUtils.deleteDirectory(path, linkOptionArray, deleteOptionArray) : PathUtils.deleteFile(path, linkOptionArray, deleteOptionArray);
    }

    public static Counters.PathCounters deleteDirectory(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws NoSuchFileException, IOException {
        long l2;
        if (Files.isDirectory(path, linkOptionArray)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters.PathCounters pathCounters = Counters.longPathCounters();
        boolean bl2 = Files.exists(path, linkOptionArray);
        long l3 = l2 = bl2 && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
        if (PathUtils.overrideReadOnly(deleteOptionArray) && bl2) {
            PathUtils.setReadOnly(path, false, linkOptionArray);
        }
        if (Files.deleteIfExists(path)) {
            pathCounters.getFileCounter().increment();
            pathCounters.getByteCounter().add(l2);
        }
        return pathCounters;
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl2 = !directoryStream.iterator().hasNext();
            return bl2;
        }
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static Path setReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        PosixFileAttributeView posixFileAttributeView;
        ArrayList<IOException> arrayList = new ArrayList<IOException>(2);
        DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
        if (dosFileAttributeView != null) {
            try {
                dosFileAttributeView.setReadOnly(bl2);
                return path;
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if ((posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptionArray)) != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            Set<PosixFilePermission> set = posixFileAttributes.permissions();
            set.remove((Object)PosixFilePermission.OWNER_WRITE);
            set.remove((Object)PosixFilePermission.GROUP_WRITE);
            set.remove((Object)PosixFilePermission.OTHERS_WRITE);
            try {
                return Files.setPosixFilePermissions(path, set);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(path.toString(), arrayList);
        }
        throw new IOException(String.format("No DosFileAttributeView or PosixFileAttributeView for '%s' (linkOptions=%s)", path, Arrays.toString(linkOptionArray)));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path) throws IOException {
        Files.walkFileTree(path, t2);
        return t2;
    }
}

