/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.ContentReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected DupDetector _dups;
    protected JsonReadContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n2, int n3, int n4) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n2;
        this._lineNr = n3;
        this._columnNr = n4;
        this._index = -1;
    }

    public void reset(int n2, int n3, int n4) {
        this._type = n2;
        this._index = -1;
        this._lineNr = n3;
        this._columnNr = n4;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public JsonReadContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, 1, 0);
    }

    public JsonReadContext createChildArrayContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 1, n2, n3);
        } else {
            jsonReadContext.reset(1, n2, n3);
        }
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 2, n2, n3);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n2, n3);
        return jsonReadContext;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    @Override
    public JsonLocation startLocation(ContentReference contentReference) {
        long l2 = -1L;
        return new JsonLocation(contentReference, l2, this._lineNr, this._columnNr);
    }

    public JsonReadContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean expectComma() {
        int n2 = ++this._index;
        return this._type != 0 && n2 > 0;
    }

    public void setCurrentName(String string) throws JsonProcessingException {
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            Object object = dupDetector.getSource();
            throw new JsonParseException(object instanceof JsonParser ? (JsonParser)object : null, "Duplicate field '" + string + "'");
        }
    }
}

