/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializerNR;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer {
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;
    protected JavaType _listType;
    protected JavaType _mapType;
    protected final boolean _nonMerging;

    @Deprecated
    public UntypedObjectDeserializer() {
        this(null, null);
    }

    public UntypedObjectDeserializer(JavaType javaType, JavaType javaType2) {
        super(Object.class);
        this._listType = javaType;
        this._mapType = javaType2;
        this._nonMerging = false;
    }

    protected UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, boolean bl2) {
        super(Object.class);
        this._mapDeserializer = untypedObjectDeserializer._mapDeserializer;
        this._listDeserializer = untypedObjectDeserializer._listDeserializer;
        this._stringDeserializer = untypedObjectDeserializer._stringDeserializer;
        this._numberDeserializer = untypedObjectDeserializer._numberDeserializer;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
        this._nonMerging = bl2;
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        JavaType javaType = deserializationContext.constructType(Object.class);
        JavaType javaType2 = deserializationContext.constructType(String.class);
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        this._listDeserializer = this._listType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructCollectionType(List.class, javaType))) : this._findCustomDeser(deserializationContext, this._listType);
        this._mapDeserializer = this._mapType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructMapType(Map.class, javaType2, javaType))) : this._findCustomDeser(deserializationContext, this._mapType);
        this._stringDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, javaType2));
        this._numberDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructType((Type)((Object)Number.class))));
        JavaType javaType3 = TypeFactory.unknownType();
        this._mapDeserializer = deserializationContext.handleSecondaryContextualization(this._mapDeserializer, null, javaType3);
        this._listDeserializer = deserializationContext.handleSecondaryContextualization(this._listDeserializer, null, javaType3);
        this._stringDeserializer = deserializationContext.handleSecondaryContextualization(this._stringDeserializer, null, javaType3);
        this._numberDeserializer = deserializationContext.handleSecondaryContextualization(this._numberDeserializer, null, javaType3);
    }

    protected JsonDeserializer<Object> _findCustomDeser(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        return deserializationContext.findNonContextualValueDeserializer(javaType);
    }

    protected JsonDeserializer<Object> _clearIfStdImpl(JsonDeserializer<Object> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer) ? null : jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        boolean bl2;
        boolean bl3 = bl2 = beanProperty == null && Boolean.FALSE.equals(deserializationContext.getConfig().getDefaultMergeable(Object.class));
        if (this._stringDeserializer == null && this._numberDeserializer == null && this._mapDeserializer == null && this._listDeserializer == null && this.getClass() == UntypedObjectDeserializer.class) {
            return UntypedObjectDeserializerNR.instance(bl2);
        }
        if (bl2 != this._nonMerging) {
            return new UntypedObjectDeserializer(this, bl2);
        }
        return this;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._nonMerging) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (object instanceof Map) {
                    return this.mapObject(jsonParser, deserializationContext, (Map)object);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case 3: {
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (object instanceof Collection) {
                    return this.mapArray(jsonParser, deserializationContext, (Collection)object);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return this.deserialize(jsonParser, deserializationContext);
    }

    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return new ArrayList(2);
        }
        Object object = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            return arrayList;
        }
        Object object2 = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            arrayList.add(object2);
            return arrayList;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        objectArray[n2++] = object;
        objectArray[n2++] = object2;
        int n3 = n2;
        do {
            object = this.deserialize(jsonParser, deserializationContext);
            ++n3;
            if (n2 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n2 = 0;
            }
            objectArray[n2++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        objectBuffer.completeAndClearBuffer(objectArray, n2, arrayList);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return arrayList;
    }

    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            collection.add(this.deserialize(jsonParser, deserializationContext));
        }
        return collection;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            string = jsonParser.nextFieldName();
        } else if (jsonToken == JsonToken.FIELD_NAME) {
            string = jsonParser.currentName();
        } else {
            if (jsonToken != JsonToken.END_OBJECT) {
                return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
            }
            string = null;
        }
        if (string == null) {
            return new LinkedHashMap(2);
        }
        jsonParser.nextToken();
        Object object = this.deserialize(jsonParser, deserializationContext);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(2);
            linkedHashMap.put(string, object);
            return linkedHashMap;
        }
        jsonParser.nextToken();
        Object object2 = this.deserialize(jsonParser, deserializationContext);
        String string3 = jsonParser.nextFieldName();
        if (string3 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put(string, object);
            if (linkedHashMap.put(string2, object2) != null) {
                return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string, object, object2, string3);
            }
            return linkedHashMap;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(string, object);
        if (linkedHashMap.put(string2, object2) != null) {
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string, object, object2, string3);
        }
        do {
            jsonParser.nextToken();
            Object object3 = this.deserialize(jsonParser, deserializationContext);
            Object object4 = linkedHashMap.put(string3, object3);
            if (object4 == null) continue;
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string3, object4, object3, jsonParser.nextFieldName());
        } while ((string3 = jsonParser.nextFieldName()) != null);
        return linkedHashMap;
    }

    protected Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) throws IOException {
        boolean bl2 = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (bl2) {
            this._squashDups(map, string, object, object2);
        }
        while (string2 != null) {
            jsonParser.nextToken();
            object2 = this.deserialize(jsonParser, deserializationContext);
            object = map.put(string2, object2);
            if (object != null && bl2) {
                this._squashDups(map, string, object, object2);
            }
            string2 = jsonParser.nextFieldName();
        }
        return map;
    }

    private void _squashDups(Map<String, Object> map, String string, Object object, Object object2) {
        if (object instanceof List) {
            ((List)object).add(object2);
            map.put(string, object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            arrayList.add(object2);
            map.put(string, arrayList);
        }
    }

    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object[] objectArray;
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray2 = objectBuffer.resetAndStart();
        int n2 = 0;
        do {
            objectArray = this.deserialize(jsonParser, deserializationContext);
            if (n2 >= objectArray2.length) {
                objectArray2 = objectBuffer.appendCompletedChunk(objectArray2);
                n2 = 0;
            }
            objectArray2[n2++] = objectArray;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        objectArray = objectBuffer.completeAndClearBuffer(objectArray2, n2);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return objectArray;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        if (jsonToken == JsonToken.END_OBJECT) {
            return map;
        }
        String string = jsonParser.currentName();
        do {
            jsonParser.nextToken();
            Object object = map.get(string);
            Object object2 = object != null ? this.deserialize(jsonParser, deserializationContext, object) : this.deserialize(jsonParser, deserializationContext);
            if (object2 == object) continue;
            map.put(string, object2);
        } while ((string = jsonParser.nextFieldName()) != null);
        return map;
    }
}

